/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: CommunicationsRCE.java,v 1.3 2001/06/17 09:37:28 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.comm.talon.components;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 *
 * <p>
 * A CommunciationsRCE performs the same role that an RCE does except it
 * forwards all operations to a remove RMF/Sierra installation.  This is done by
 * wrapping an existing RCE with any logic necessary to communicate with a
 * remote machine.
 *
 * <p>This architecture means we can support any protocol, any topology and any
 * future protocols/topologies that do not exist yet.  This is due to the fact
 * that a CommunciationsRCE has almost *no* requirements and offloads most of
 * its burden to the implementation class.  This in essence will allow Sierra to
 * support almost infinite growth without rewriting any existing code that uses 
 * it. 
 *
 * Example:
 * <pre>
 *
 *    /   SOAP-RCE    \                                    /   SOAP-RCE    \
 *   |                 |               ( IP )             |                 |
 *   |   [Local-RCE]   |  <--- Network ( Gnutella ) --->  |   [Remote-RCE]  |
 *   |                 |               ( Freenet )        |                 |
 *    \   SOAP-RCE    /                                    \   SOAP-RCE    /
 *
 * </pre>
 * 
 * @see RCE
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: CommunicationsRCE.java,v 1.3 2001/06/17 09:37:28 burton Exp $
 */
public interface CommunicationsRCE extends RCE {
    
} 

