;;; prj.el --- Emacs JDE project settings

;; $Id: prj.el,v 1.13 2001/06/25 03:53:46 burton Exp $

;; Copyright (C) 1997-2000 Free Software Foundation, Inc.

;; Author: Kevin A. Burton (burton@openprivacy.org)
;; Maintainer: Kevin A. Burton (burton@openprivacy.org)
;; Location: http://relativity.yi.org
;; Keywords: 
;; Version: 1.0.0

;; This file is [not yet] part of GNU Emacs.

;; This program is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free Software
;; Foundation; either version 2 of the License, or any later version.
;;
;; This program is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
;; FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
;; details.
;;
;; You should have received a copy of the GNU General Public License along with
;; this program; if not, write to the Free Software Foundation, Inc., 59 Temple
;; Place - Suite 330, Boston, MA 02111-1307, USA.

;;; Commentary:

;; 

;; ==============================================================================
;; GLOBAL SETTINGS                                                   
;; ==============================================================================

(load-file "~/el/my-jde.el")

(setq jde-compile-option-command-line-args "-depend -nowarn +E +D")
(setq jde-bug-jdk-directory "/usr/local/jdk1.3/")
(setq jde-compile-option-directory (expand-file-name "~/tmp/classes"))
(setq jde-db-source-directories java-open-source-path)
(setq jde-compiler "jikes")
(setq jde-db-debugger (quote ("JDEbug" "jdb" . "Executable")))
(setq jde-run-classic-mode-vm t)


;; ==============================================================================
;; PROJECTS SPECIFIC SETTINGS                                                   
;; ==============================================================================

(setq jde-project-name "Sierra")

(setq my-java-vm-args '("-Dtalon.project=sierra")) 
(setq my-java-application-args '("test"))

(setq jde-javadoc-gen-destination-directory (expand-file-name "~/tmp/javadoc/sierra"))
(setq jde-build-use-make t)
(setq jde-run-working-directory "/projects/sierra/build")
(setq jde-run-application-class "org.apache.tools.ant.Main")
(setq jde-run-option-vm-args my-java-vm-args)
(setq jde-db-option-vm-args my-java-vm-args)
(setq jde-run-option-application-args my-java-application-args)
(setq jde-db-option-application-args my-java-application-args)
(setq jde-make-program "~/bin/quick-jikes-build.sh /projects/sierra/src/java")

(setq jde-guess-imports '( "talon.*" "talon.components.*" "talon.util.net.*" "org.openprivacy.sierra.util.*" ))

