/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public class HTMLSerializer
extends BaseMarkupSerializer {
    private static boolean _xhtml;
    public static String XHTMLNamespace;

    protected HTMLSerializer(boolean bl, OutputFormat outputFormat) {
        this(outputFormat);
        _xhtml = bl;
    }

    public HTMLSerializer() {
        this.setOutputFormat(null);
    }

    public HTMLSerializer(OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
    }

    public HTMLSerializer(Writer writer, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        this.setOutputCharStream(writer);
    }

    public HTMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        try {
            this.setOutputByteStream(outputStream);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            super.setOutputFormat(new OutputFormat("html", null, false));
            return;
        }
        super.setOutputFormat(outputFormat);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4;
        String string5;
        Object object;
        boolean bl;
        boolean bl2 = false;
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string2 == null ? string3 : string2);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        if (string3 == null) {
            string3 = string2;
            if (string != null && ((String)(object = this.getPrefix(string))).length() > 0) {
                string3 = String.valueOf(object) + ":" + string2;
            }
            bl2 = true;
        }
        String string6 = string == null ? string3 : (string.equals(XHTMLNamespace) ? string2 : null);
        if (_xhtml) {
            this.printText(String.valueOf('<') + string3.toLowerCase());
        } else {
            this.printText(String.valueOf('<') + string3);
        }
        this.indent();
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                this.printSpace();
                string5 = attributes.getRawName(n).toLowerCase();
                string4 = attributes.getValue(n);
                if (_xhtml || string != null) {
                    if (string4 == null) {
                        this.printText(String.valueOf(string5) + "=\"\"");
                    } else {
                        this.printText(String.valueOf(string5) + "=\"" + this.escape(string4) + '\"');
                    }
                } else if (string4 == null || string4.length() == 0) {
                    this.printText(string5);
                } else if (HTMLdtd.isURI(string3, string5)) {
                    this.printText(String.valueOf(string5) + "=\"" + this.escapeURI(string4) + '\"');
                } else if (HTMLdtd.isBoolean(string3, string5)) {
                    this.printText(string5);
                } else {
                    this.printText(String.valueOf(string5) + "=\"" + this.escape(string4) + '\"');
                }
                ++n;
            }
        }
        if (string6 != null && HTMLdtd.isPreserveSpace(string6)) {
            bl = true;
        }
        if (bl2) {
            object = this._prefixes.keys();
            while (object.hasMoreElements()) {
                this.printSpace();
                string4 = (String)object.nextElement();
                string5 = (String)this._prefixes.get(string4);
                if (string5.length() == 0) {
                    this.printText("xmlns=\"" + string4 + '\"');
                    continue;
                }
                this.printText("xmlns:" + string5 + "=\"" + string4 + '\"');
            }
        }
        elementState = this.enterElementState(string, string2, string3, bl);
        if (string6 != null && (string6.equalsIgnoreCase("A") || string6.equalsIgnoreCase("TD"))) {
            elementState.empty = false;
            this.printText(">");
        }
        if (string6 != null && (string3.equalsIgnoreCase("SCRIPT") || string3.equalsIgnoreCase("STYLE"))) {
            if (_xhtml) {
                elementState.doCData = true;
                return;
            }
            elementState.unescaped = true;
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.unindent();
        ElementState elementState = this.getElementState();
        String string4 = elementState.namespaceURI == null ? elementState.rawName : (elementState.namespaceURI.equals(XHTMLNamespace) ? elementState.localName : null);
        if (_xhtml) {
            if (elementState.empty) {
                this.printText(" />");
            } else {
                if (elementState.inCData) {
                    this.printText("]]>");
                }
                this.printText("</" + elementState.rawName.toLowerCase() + ">");
            }
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            if (string4 == null || !HTMLdtd.isOnlyOpening(string4)) {
                if (this._format.getIndenting() && !elementState.preserveSpace && elementState.afterElement) {
                    this.breakLine();
                }
                if (elementState.inCData) {
                    this.printText("]]>");
                }
                this.printText("</" + elementState.rawName + ">");
            }
        }
        elementState = this.leaveElementState();
        if (elementState != null) {
            if (string4 == null || !string4.equalsIgnoreCase("A") && !string4.equalsIgnoreCase("TD")) {
                elementState.afterElement = true;
            }
            elementState.empty = false;
            return;
        }
        this.flush();
    }

    public void characters(char[] cArray, int n, int n2) {
        ElementState elementState = this.content();
        if (elementState != null) {
            elementState.doCData = false;
        }
        super.characters(cArray, n, n2);
    }

    public void startDocument() {
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
    }

    public void startElement(String string, AttributeList attributeList) {
        boolean bl;
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        if (_xhtml) {
            this.printText(String.valueOf('<') + string.toLowerCase());
        } else {
            this.printText(String.valueOf('<') + string);
        }
        this.indent();
        if (attributeList != null) {
            int n = 0;
            while (n < attributeList.getLength()) {
                this.printSpace();
                String string2 = attributeList.getName(n).toLowerCase();
                String string3 = attributeList.getValue(n);
                if (_xhtml) {
                    if (string3 == null) {
                        this.printText(String.valueOf(string2) + "=\"\"");
                    } else {
                        this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                    }
                } else if (string3 == null || string3.length() == 0) {
                    this.printText(string2);
                } else if (HTMLdtd.isURI(string, string2)) {
                    this.printText(String.valueOf(string2) + "=\"" + this.escapeURI(string3) + '\"');
                } else if (HTMLdtd.isBoolean(string, string2)) {
                    this.printText(string2);
                } else {
                    this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                }
                ++n;
            }
        }
        if (HTMLdtd.isPreserveSpace(string)) {
            bl = true;
        }
        elementState = this.enterElementState(null, null, string, bl);
        if (string.equalsIgnoreCase("A") || string.equalsIgnoreCase("TD")) {
            elementState.empty = false;
            this.printText(">");
        }
        if (string.equalsIgnoreCase("SCRIPT") || string.equalsIgnoreCase("STYLE")) {
            if (_xhtml) {
                elementState.doCData = true;
                return;
            }
            elementState.unescaped = true;
        }
    }

    public void endElement(String string) {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) {
        this.leaveDTD();
        if (!this._started) {
            if (this._docTypePublicId == null && this._docTypeSystemId == null) {
                if (_xhtml) {
                    this._docTypePublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                } else {
                    this._docTypePublicId = "-//W3C//DTD HTML 4.0//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                }
            }
            if (!(this._docTypePublicId == null || _xhtml && this._docTypeSystemId == null)) {
                this.printText("<!DOCTYPE HTML PUBLIC ");
                this.printDoctypeURL(this._docTypePublicId);
                if (this._docTypeSystemId != null) {
                    if (this._format.getIndenting()) {
                        this.breakLine();
                        this.printText("                      ");
                    } else {
                        this.printText(" ");
                    }
                    this.printDoctypeURL(this._docTypeSystemId);
                }
                this.printText(">");
                this.breakLine();
            } else if (this._docTypeSystemId != null) {
                this.printText("<!DOCTYPE HTML SYSTEM ");
                this.printDoctypeURL(this._docTypeSystemId);
                this.printText(">");
                this.breakLine();
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element element) {
        boolean bl;
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        if (_xhtml) {
            this.printText(String.valueOf('<') + string.toLowerCase());
        } else {
            this.printText(String.valueOf('<') + string);
        }
        this.indent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName().toLowerCase();
                String string3 = attr.getValue();
                if (attr.getSpecified()) {
                    this.printSpace();
                    if (_xhtml) {
                        if (string3 == null) {
                            this.printText(String.valueOf(string2) + "=\"\"");
                        } else {
                            this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                        }
                    } else if (string3 == null || string3.length() == 0) {
                        this.printText(string2);
                    } else if (HTMLdtd.isURI(string, string2)) {
                        this.printText(String.valueOf(string2) + "=\"" + this.escapeURI(string3) + '\"');
                    } else if (HTMLdtd.isBoolean(string, string2)) {
                        this.printText(string2);
                    } else {
                        this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                    }
                }
                ++n;
            }
        }
        if (HTMLdtd.isPreserveSpace(string)) {
            bl = true;
        }
        if (element.hasChildNodes() || !HTMLdtd.isEmptyTag(string)) {
            elementState = this.enterElementState(null, null, string, bl);
            if (string.equalsIgnoreCase("A") || string.equalsIgnoreCase("TD")) {
                elementState.empty = false;
                this.printText(">");
            }
            if (string.equalsIgnoreCase("SCRIPT") || string.equalsIgnoreCase("STYLE")) {
                if (_xhtml) {
                    elementState.doCData = true;
                } else {
                    elementState.unescaped = true;
                }
            }
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(null, null, string);
            return;
        }
        this.unindent();
        if (_xhtml) {
            this.printText(" />");
        } else {
            this.printText(">");
        }
        if (elementState != null) {
            elementState.afterElement = true;
            elementState.empty = false;
        }
    }

    protected void characters(String string, boolean bl) {
        ElementState elementState = this.content();
        if (elementState != null) {
            elementState.doCData = false;
        }
        super.characters(string, bl);
    }

    protected String getEntityRef(char c) {
        return HTMLdtd.fromChar(c);
    }

    protected String escapeURI(String string) {
        int n = string.indexOf("\"");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    static {
        XHTMLNamespace = "";
    }
}

