/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.mm.mysql.PushBackTokenizer;
import org.gjt.mm.mysql.Token;

class EscapeProcessor {
    public synchronized String escapeSQL(String SQL) throws SQLException {
        boolean replaceEscapeSequence = false;
        String EscapeSequence = null;
        StringBuffer NewSQL = new StringBuffer();
        boolean inBraces = false;
        boolean inQuotes = false;
        boolean escaped = false;
        boolean unrecognizedEscape = false;
        String OpeningBrace = "";
        if (SQL == null) {
            return null;
        }
        int begin_brace = SQL.indexOf("{");
        int next_end_brace = SQL.indexOf("}", begin_brace);
        if (next_end_brace == -1) {
            return SQL;
        }
        PushBackTokenizer PBT = new PushBackTokenizer(SQL, "{}'", true);
        while (PBT.hasMoreTokens()) {
            String Token2 = PBT.nextToken();
            if (Token2.startsWith("{")) {
                if (escaped) {
                    NewSQL.append(Token2);
                    escaped = false;
                } else {
                    NewSQL.append(OpeningBrace);
                    inBraces = true;
                    OpeningBrace = Token2;
                }
            } else if (Token2.startsWith("}")) {
                if (escaped) {
                    NewSQL.append(Token2);
                    escaped = false;
                } else if (!inBraces) {
                    NewSQL.append(Token2);
                } else {
                    inBraces = false;
                    if (!OpeningBrace.equals("")) {
                        NewSQL.append(OpeningBrace);
                        NewSQL.append(Token2);
                        OpeningBrace = "";
                    }
                    if (unrecognizedEscape) {
                        NewSQL.append(Token2);
                        unrecognizedEscape = false;
                    }
                }
            } else if (Token2.startsWith("'")) {
                if (escaped) {
                    NewSQL.append(Token2);
                    escaped = false;
                } else {
                    NewSQL.append(Token2);
                    inQuotes = !inQuotes;
                }
            } else if (inBraces && !inQuotes) {
                String DD;
                String MM;
                String YYYY;
                StringTokenizer ST;
                String Argument;
                if (Token2.startsWith("escape")) {
                    try {
                        StringTokenizer ST2 = new StringTokenizer(Token2, " '");
                        ST2.nextToken();
                        EscapeSequence = ST2.nextToken();
                        if (EscapeSequence.length() < 3) {
                            throw new SQLException("Syntax error for escape sequence '" + Token2 + "'", "42000");
                        }
                        EscapeSequence = EscapeSequence.substring(1, EscapeSequence.length() - 1);
                        replaceEscapeSequence = true;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for escape sequence '" + Token2 + "'", "42000");
                    }
                }
                if (Token2.startsWith("fn")) {
                    int start_pos = Token2.indexOf("fn ") + 3;
                    int end_pos = Token2.length();
                    NewSQL.append(Token2.substring(start_pos, end_pos));
                    try {
                        NewSQL.append(EscapeProcessor.parseComplexArgument(PBT));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for FN escape code", "42000");
                    }
                }
                if (Token2.startsWith("d")) {
                    Argument = "";
                    try {
                        Argument = EscapeProcessor.parseArgument(PBT);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Illegal argument for DATE escape code '" + Argument + "'", "42000");
                    }
                    try {
                        ST = new StringTokenizer(Argument, " -");
                        YYYY = ST.nextToken();
                        MM = ST.nextToken();
                        DD = ST.nextToken();
                        String DateString = "'" + YYYY + "-" + MM + "-" + DD + "'";
                        NewSQL.append(DateString);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for DATE escape sequence '" + Argument + "'", "42000");
                    }
                }
                if (Token2.startsWith("ts")) {
                    Argument = "";
                    try {
                        Argument = EscapeProcessor.parseArgument(PBT);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Illegal argument for TIMESTAMP escape code '" + Argument + "'", "42000");
                    }
                    try {
                        ST = new StringTokenizer(Argument, " .-:");
                        YYYY = ST.nextToken();
                        MM = ST.nextToken();
                        DD = ST.nextToken();
                        String HH = ST.nextToken();
                        String Mm = ST.nextToken();
                        String SS = ST.nextToken();
                        String F = "";
                        if (ST.hasMoreTokens()) {
                            F = ST.nextToken();
                        }
                        NewSQL.append("'").append(YYYY).append("-").append(MM).append("-").append(DD).append(" ").append(HH).append(":").append(Mm).append(":").append(SS).append("'");
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + Argument + "'", "42000");
                    }
                }
                if (Token2.startsWith("t")) {
                    Argument = "";
                    try {
                        Argument = EscapeProcessor.parseArgument(PBT);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Illegal argument for TIME escape code '" + Argument + "'", "42000");
                    }
                    try {
                        ST = new StringTokenizer(Argument, " ':");
                        String HH = ST.nextToken();
                        MM = ST.nextToken();
                        String SS = ST.nextToken();
                        String TimeString = "'" + HH + ":" + MM + ":" + SS + "'";
                        NewSQL.append(TimeString);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for escape sequence '" + Argument + "'", "42000");
                    }
                }
                if (Token2.startsWith("call") || Token2.startsWith("? = call")) {
                    throw new SQLException("Stored procedures not supported: " + Token2, "S1C00");
                }
                if (Token2.startsWith("oj")) {
                    try {
                        NewSQL.append(EscapeProcessor.parseComplexArgument(PBT));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for OJ escape code", "42000");
                    }
                } else {
                    NewSQL.append(OpeningBrace);
                    NewSQL.append(Token2);
                    unrecognizedEscape = true;
                    OpeningBrace = "";
                }
                OpeningBrace = "";
            } else {
                NewSQL.append(Token2);
            }
            if (!Token2.endsWith("\\")) continue;
            escaped = true;
        }
        NewSQL.append(OpeningBrace);
        String EscapedSQL = NewSQL.toString();
        if (replaceEscapeSequence) {
            String CurrentSQL = EscapedSQL;
            while (CurrentSQL.indexOf(EscapeSequence) != -1) {
                int escapePos = CurrentSQL.indexOf(EscapeSequence);
                String LHS = CurrentSQL.substring(0, escapePos);
                String RHS = CurrentSQL.substring(escapePos + 1, CurrentSQL.length());
                CurrentSQL = String.valueOf(LHS) + "\\" + RHS;
            }
            EscapedSQL = CurrentSQL;
        }
        if (EscapedSQL.indexOf("||") != -1) {
            EscapedSQL = EscapeProcessor.doConcat(EscapedSQL);
        }
        return EscapedSQL;
    }

    static String doConcat(String SQL) {
        Vector<Token> TokenList = new Vector<Token>();
        StringTokenizer ST = new StringTokenizer(SQL, " '", true);
        boolean inquotes = false;
        StringBuffer QuotedString = null;
        while (ST.hasMoreTokens()) {
            Token Tok;
            String T = ST.nextToken();
            if (T.equals("'")) {
                if (inquotes) {
                    inquotes = false;
                    Tok = new Token(QuotedString.toString(), true);
                    TokenList.addElement(Tok);
                    continue;
                }
                inquotes = true;
                QuotedString = new StringBuffer();
                continue;
            }
            if (inquotes) {
                QuotedString.append(T);
                continue;
            }
            Tok = new Token(T, false);
            TokenList.addElement(Tok);
        }
        int pos = 0;
        int length = TokenList.size();
        Stack<Token> ToDo = new Stack<Token>();
        while (pos < length) {
            Token T1 = (Token)TokenList.elementAt(pos);
            if (T1.Value.equals("||")) {
                Token Pre = (Token)ToDo.pop();
                Token Post = (Token)TokenList.elementAt(++pos);
                Token Concat = new Token(String.valueOf(Pre.Value) + Post.Value, true);
                ToDo.push(Concat);
                ++pos;
                continue;
            }
            ToDo.push(T1);
            ++pos;
        }
        length = ToDo.size();
        StringBuffer NewQuery = new StringBuffer();
        int i = 0;
        while (i < length) {
            Token T = (Token)ToDo.elementAt(i);
            if (T.quoted) {
                NewQuery.append("'");
                NewQuery.append(T.Value);
                NewQuery.append("'");
            } else {
                NewQuery.append(T.Value);
            }
            ++i;
        }
        return NewQuery.toString();
    }

    private static final String parseArgument(PushBackTokenizer Tokenizer) throws NoSuchElementException {
        StringBuffer Argument = new StringBuffer();
        boolean done_parsing = false;
        boolean seen_one_quote = false;
        while (!done_parsing) {
            String Tok = Tokenizer.nextToken();
            if (Tok.equals("'")) {
                if (seen_one_quote) {
                    done_parsing = true;
                    continue;
                }
                seen_one_quote = true;
                continue;
            }
            Argument.append(Tok);
        }
        return Argument.toString();
    }

    private static final String parseComplexArgument(PushBackTokenizer Tokenizer) throws NoSuchElementException {
        StringBuffer Argument = new StringBuffer();
        boolean done_parsing = false;
        boolean in_quotes = false;
        while (!done_parsing) {
            String Tok = Tokenizer.nextToken();
            if (Tok.equals("'")) {
                in_quotes = !in_quotes;
                Argument.append(Tok);
                continue;
            }
            if (!in_quotes && Tok.equals("}")) {
                done_parsing = true;
                Tokenizer.pushBack();
                continue;
            }
            Argument.append(Tok);
        }
        return Argument.toString();
    }

    EscapeProcessor() {
    }
}

