/*
 * Decompiled with CFR 0.152.
 */
package talon.util;

import talon.TalonException;

public class Base64 {
    private static char[] base64Alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '~', '-'};
    private static byte[] base64Reverse = new byte[128];

    public static String encode(byte[] in) {
        return Base64.encode(in, false);
    }

    public static String encode(byte[] in, boolean equalsPad) {
        char[] out = new char[(in.length + 2) / 3 * 4];
        int rem = in.length % 3;
        int o = 0;
        int i = 0;
        while (i < in.length) {
            int val = (in[i++] & 0xFF) << 16;
            if (i < in.length) {
                val |= (in[i++] & 0xFF) << 8;
            }
            if (i < in.length) {
                val |= in[i++] & 0xFF;
            }
            out[o++] = base64Alphabet[val >> 18 & 0x3F];
            out[o++] = base64Alphabet[val >> 12 & 0x3F];
            out[o++] = base64Alphabet[val >> 6 & 0x3F];
            out[o++] = base64Alphabet[val & 0x3F];
        }
        int outLen = out.length;
        switch (rem) {
            case 1: {
                outLen -= 2;
                break;
            }
            case 2: {
                --outLen;
            }
        }
        if (equalsPad) {
            while (outLen < out.length) {
                out[outLen++] = 95;
            }
        }
        return new String(out, 0, outLen);
    }

    public static byte[] decode(String inStr) throws TalonException {
        try {
            int orValue;
            int wholeOutLen;
            char[] in = inStr.toCharArray();
            int inLength = in.length;
            while (inLength > 0 && in[inLength - 1] == '_') {
                --inLength;
            }
            int blocks = inLength / 4;
            int remainder = inLength & 3;
            int wholeInLen = blocks * 4;
            int outLen = wholeOutLen = blocks * 3;
            switch (remainder) {
                case 1: {
                    throw new TalonException("illegal Base64 length");
                }
                case 2: {
                    outLen = wholeOutLen + 1;
                    break;
                }
                case 3: {
                    outLen = wholeOutLen + 2;
                    break;
                }
                default: {
                    outLen = wholeOutLen;
                }
            }
            byte[] out = new byte[outLen];
            int o = 0;
            int i = 0;
            while (i < wholeInLen) {
                byte in1 = base64Reverse[in[i]];
                byte in2 = base64Reverse[in[i + 1]];
                byte in3 = base64Reverse[in[i + 2]];
                byte in4 = base64Reverse[in[i + 3]];
                int orValue2 = in1 | in2 | in3 | in4;
                if ((orValue2 & 0x80) != 0) {
                    throw new TalonException("illegal Base64 character");
                }
                int outVal = in1 << 18 | in2 << 12 | in3 << 6 | in4;
                out[o] = (byte)(outVal >> 16);
                out[o + 1] = (byte)(outVal >> 8);
                out[o + 2] = (byte)outVal;
                i += 4;
                o += 3;
            }
            switch (remainder) {
                case 2: {
                    byte in1 = base64Reverse[in[i]];
                    byte in2 = base64Reverse[in[i + 1]];
                    orValue = in1 | in2;
                    int outVal = in1 << 18 | in2 << 12;
                    out[o] = (byte)(outVal >> 16);
                    break;
                }
                case 3: {
                    byte in1 = base64Reverse[in[i]];
                    byte in2 = base64Reverse[in[i + 1]];
                    byte in3 = base64Reverse[in[i + 2]];
                    orValue = in1 | in2 | in3;
                    int outVal = in1 << 18 | in2 << 12 | in3 << 6;
                    out[o] = (byte)(outVal >> 16);
                    out[o + 1] = (byte)(outVal >> 8);
                    break;
                }
                default: {
                    orValue = 0;
                }
            }
            if ((orValue & 0x80) != 0) {
                throw new TalonException("illegal Base64 character");
            }
            return out;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new TalonException("illegal Base64 character");
        }
    }

    static {
        int i = 0;
        while (i < base64Reverse.length) {
            Base64.base64Reverse[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < base64Alphabet.length) {
            Base64.base64Reverse[Base64.base64Alphabet[i2]] = (byte)i2;
            ++i2;
        }
    }
}

