/*
 * Decompiled with CFR 0.152.
 */
package org.arrowhead.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.arrowhead.util.LogPrintStream;
import org.arrowhead.util.OutputHandler;

public class HttpPostUtil {
    public static final String HTTP_VERSION = "HTTP/1.0";
    private Hashtable params = new Hashtable();
    private String server = null;
    private String action = null;
    private int port;
    private File file = null;
    private String contentType = null;

    public HttpPostUtil(String string, int n, String string2, String string3, File file) {
        this.server = string;
        this.port = n;
        this.action = string2;
        this.contentType = string3;
        this.file = file;
    }

    public HttpPostUtil(String string, int n, String string2, String string3, String string4) {
        this(string, n, string2, string3, new File(string4));
    }

    public void addParameter(String string, String string2) {
        this.params.put(string, string2);
    }

    public void execute() throws Exception {
        Socket socket = new Socket(this.server, this.port);
        OutputHandler outputHandler = new OutputHandler(socket.getInputStream());
        outputHandler.start();
        LogPrintStream logPrintStream = new LogPrintStream(socket.getOutputStream());
        logPrintStream.println("POST " + this.action + " " + HTTP_VERSION);
        logPrintStream.println("Content-Type: " + this.contentType);
        logPrintStream.println("Content-Length: " + this.file.length());
        Enumeration enumeration = this.params.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            logPrintStream.println(string + ": " + this.params.get(string));
        }
        try {
            logPrintStream.print("\n\n");
            logPrintStream.print(this.getData());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getData() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[200];
        int n = 0;
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        return byteArrayOutputStream.toString();
    }
}

