/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class PatternSet
extends DataType {
    private Vector includeList = new Vector();
    private Vector excludeList = new Vector();
    private File incl = null;
    private File excl = null;

    public void setRefid(Reference reference) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    public NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    public void setIncludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.createInclude().setName(stringTokenizer.nextToken());
            }
        }
    }

    public void setExcludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.createExclude().setName(stringTokenizer.nextToken());
            }
        }
    }

    private NameEntry addPatternToList(Vector vector) {
        NameEntry nameEntry = new NameEntry();
        vector.addElement(nameEntry);
        return nameEntry;
    }

    public void setIncludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!file.exists()) {
            throw new BuildException("Includesfile " + file.getAbsolutePath() + " not found.");
        }
        this.incl = file;
    }

    public void setExcludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!file.exists()) {
            throw new BuildException("Excludesfile " + file.getAbsolutePath() + " not found.");
        }
        this.excl = file;
    }

    private void readPatterns(File file, Vector vector, Project project) throws BuildException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.length() > 0) {
                    string = ProjectHelper.replaceProperties(project, string, project.getProperties());
                    this.addPatternToList(vector).setName(string);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            String string = "An error occured while reading from pattern file: " + file;
            throw new BuildException(string, iOException);
        }
    }

    public void append(PatternSet patternSet, Project project) {
        String[] stringArray;
        if (this.isReference()) {
            throw new BuildException("Cannot append to a reference");
        }
        String[] stringArray2 = patternSet.getIncludePatterns(project);
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                this.createInclude().setName(stringArray2[n]);
                ++n;
            }
        }
        if ((stringArray = patternSet.getExcludePatterns(project)) != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.createExclude().setName(stringArray[n]);
                ++n;
            }
        }
    }

    public String[] getIncludePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getIncludePatterns(project);
        }
        this.readFiles(project);
        return this.makeArray(this.includeList, project);
    }

    public String[] getExcludePatterns(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getExcludePatterns(project);
        }
        this.readFiles(project);
        return this.makeArray(this.excludeList, project);
    }

    boolean hasPatterns() {
        return this.incl != null || this.excl != null || this.includeList.size() > 0 || this.excludeList.size() > 0;
    }

    private PatternSet getRef(Project project) {
        Object object;
        if (!this.checked) {
            object = new Stack<PatternSet>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, project);
        }
        if (!((object = this.ref.getReferencedObject(project)) instanceof PatternSet)) {
            String string = this.ref.getRefId() + " doesn't denote a patternset";
            throw new BuildException(string);
        }
        return (PatternSet)object;
    }

    private String[] makeArray(Vector vector, Project project) {
        Object object;
        if (vector.size() == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (NameEntry)enumeration.nextElement();
            String string = object.evalName(project);
            if (string == null || string.length() <= 0) continue;
            vector2.addElement(string);
        }
        object = new String[vector2.size()];
        vector2.copyInto((Object[])object);
        return object;
    }

    private void readFiles(Project project) {
        if (this.incl != null) {
            this.readPatterns(this.incl, this.includeList, project);
            this.incl = null;
        }
        if (this.excl != null) {
            this.readPatterns(this.excl, this.excludeList, project);
            this.excl = null;
        }
    }

    public String toString() {
        return "patternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    public class NameEntry {
        private String name;
        private String ifCond;
        private String unlessCond;

        public void setName(String string) {
            this.name = string;
        }

        public void setIf(String string) {
            this.ifCond = string;
        }

        public void setUnless(String string) {
            this.unlessCond = string;
        }

        public String getName() {
            return this.name;
        }

        public String evalName(Project project) {
            return this.valid(project) ? this.name : null;
        }

        private boolean valid(Project project) {
            if (this.ifCond != null && project.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || project.getProperty(this.unlessCond) == null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            if (this.ifCond != null || this.unlessCond != null) {
                stringBuffer.append(":");
                String string = "";
                if (this.ifCond != null) {
                    stringBuffer.append("if->");
                    stringBuffer.append(this.ifCond);
                    string = ";";
                }
                if (this.unlessCond != null) {
                    stringBuffer.append(string);
                    stringBuffer.append("unless->");
                    stringBuffer.append(this.unlessCond);
                }
            }
            return stringBuffer.toString();
        }
    }
}

