/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public abstract class DefaultCompilerAdapter
implements CompilerAdapter {
    protected Path src;
    protected File destDir;
    protected String encoding;
    protected boolean debug = false;
    protected boolean optimize = false;
    protected boolean deprecation = false;
    protected boolean depend = false;
    protected boolean verbose = false;
    protected String target;
    protected Path bootclasspath;
    protected Path extdirs;
    protected Path compileClasspath;
    protected Project project;
    protected Location location;
    protected boolean includeAntRuntime;
    protected boolean includeJavaRuntime;
    protected File[] compileList;
    protected static String lSep = System.getProperty("line.separator");
    protected Javac attributes;

    public void setJavac(Javac javac) {
        this.attributes = javac;
        this.src = javac.getSrcdir();
        this.destDir = javac.getDestdir();
        this.encoding = javac.getEncoding();
        this.debug = javac.getDebug();
        this.optimize = javac.getOptimize();
        this.deprecation = javac.getDeprecation();
        this.depend = javac.getDepend();
        this.verbose = javac.getVerbose();
        this.target = javac.getTarget();
        this.bootclasspath = javac.getBootclasspath();
        this.extdirs = javac.getExtdirs();
        this.compileList = javac.getFileList();
        this.compileClasspath = javac.getClasspath();
        this.project = javac.getProject();
        this.location = javac.getLocation();
        this.includeAntRuntime = javac.getIncludeantruntime();
        this.includeJavaRuntime = javac.getIncludejavaruntime();
    }

    public Javac getJavac() {
        return this.attributes;
    }

    protected Path getCompileClasspath() {
        Path path = new Path(this.project);
        if (this.destDir != null) {
            path.setLocation(this.destDir);
        }
        if (this.compileClasspath == null) {
            if (this.includeAntRuntime) {
                path.addExisting(Path.systemClasspath);
            }
        } else if (this.includeAntRuntime) {
            path.addExisting(this.compileClasspath.concatSystemClasspath("last"));
        } else {
            path.addExisting(this.compileClasspath.concatSystemClasspath("ignore"));
        }
        if (this.includeJavaRuntime) {
            if (System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") >= 0) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File(System.getProperty("java.home") + File.separator + "Packages"));
                fileSet.setIncludes("*.ZIP");
                path.addFileset(fileSet);
            } else if (Project.getJavaVersion() == "1.1") {
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "classes.zip"));
            } else {
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "classes.jar"));
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + ".." + File.separator + "Classes" + File.separator + "ui.jar"));
            }
        }
        return path;
    }

    protected Commandline setupJavacCommand() {
        Commandline commandline = new Commandline();
        Path path = this.getCompileClasspath();
        if (this.deprecation) {
            commandline.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir);
        }
        commandline.createArgument().setValue("-classpath");
        if (Project.getJavaVersion().startsWith("1.1")) {
            Path path2 = new Path(this.project);
            if (this.bootclasspath != null) {
                path2.append(this.bootclasspath);
            }
            if (this.extdirs != null) {
                this.addExtdirsToClasspath(path2);
            }
            path2.append(path);
            path2.append(this.src);
            commandline.createArgument().setPath(path2);
        } else {
            commandline.createArgument().setPath(path);
            commandline.createArgument().setValue("-sourcepath");
            commandline.createArgument().setPath(this.src);
            if (this.target != null) {
                commandline.createArgument().setValue("-target");
                commandline.createArgument().setValue(this.target);
            }
            if (this.bootclasspath != null) {
                commandline.createArgument().setValue("-bootclasspath");
                commandline.createArgument().setPath(this.bootclasspath);
            }
            if (this.extdirs != null) {
                commandline.createArgument().setValue("-extdirs");
                commandline.createArgument().setPath(this.extdirs);
            }
        }
        if (this.encoding != null) {
            commandline.createArgument().setValue("-encoding");
            commandline.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            commandline.createArgument().setValue("-g");
        } else if (Project.getJavaVersion() != "1.0" && Project.getJavaVersion() != "1.1") {
            commandline.createArgument().setValue("-g:none");
        }
        if (this.optimize) {
            commandline.createArgument().setValue("-O");
        }
        if (this.depend) {
            if (Project.getJavaVersion().startsWith("1.1")) {
                commandline.createArgument().setValue("-depend");
            } else if (Project.getJavaVersion().startsWith("1.2")) {
                commandline.createArgument().setValue("-Xdepend");
            } else {
                this.attributes.log("depend attribute is not supported by the modern compiler", 1);
            }
        }
        if (this.verbose) {
            commandline.createArgument().setValue("-verbose");
        }
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        this.attributes.log("Compilation args: " + commandline.toString(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (this.compileList.length != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        stringBuffer.append(lSep);
        int n = 0;
        while (n < this.compileList.length) {
            String string = this.compileList[n].getAbsolutePath();
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string + lSep);
            ++n;
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeExternalCompile(String[] stringArray, int n) {
        String[] stringArray2 = null;
        File file = null;
        try {
            int n2;
            Object object;
            block16: {
                if (Commandline.toString(stringArray).length() > 4096) {
                    object = null;
                    try {
                        try {
                            file = new File("jikes" + new Random(System.currentTimeMillis()).nextLong());
                            object = new PrintWriter(new FileWriter(file));
                            n2 = n;
                            while (true) {
                                if (n2 >= stringArray.length) {
                                    ((PrintWriter)object).flush();
                                    stringArray2 = new String[n + 1];
                                    System.arraycopy(stringArray, 0, stringArray2, 0, n);
                                    stringArray2[n] = "@" + file.getAbsolutePath();
                                    break;
                                }
                                ((PrintWriter)object).println(stringArray[n2]);
                                ++n2;
                            }
                        }
                        catch (IOException iOException) {
                            throw new BuildException("Error creating temporary file", iOException, this.location);
                        }
                        Object var8_9 = null;
                        if (object == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (object == null) throw throwable;
                        try {
                            ((PrintWriter)object).close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (Throwable throwable) {}
                    ((PrintWriter)object).close();
                } else {
                    stringArray2 = stringArray;
                }
            }
            try {
                object = new Execute(new LogStreamHandler(this.attributes, 2, 1));
                ((Execute)object).setAntRun(this.project);
                ((Execute)object).setWorkingDirectory(this.project.getBaseDir());
                ((Execute)object).setCommandline(stringArray2);
                ((Execute)object).execute();
                n2 = ((Execute)object).getExitValue();
                Object var11_14 = null;
                if (file == null) return n2;
                file.delete();
                return n2;
            }
            catch (IOException iOException) {
                throw new BuildException("Error running " + stringArray[0] + " compiler", iOException, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (file == null) throw throwable;
            file.delete();
            throw throwable;
        }
    }

    protected void addExtdirsToClasspath(Path path) {
        String[] stringArray;
        if (this.extdirs == null) {
            stringArray = System.getProperty("java.ext.dirs");
            if (stringArray != null) {
                this.extdirs = new Path(this.project, (String)stringArray);
            } else {
                return;
            }
        }
        stringArray = this.extdirs.list();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].endsWith(File.separator)) {
                int n2 = n;
                stringArray[n2] = stringArray[n2] + File.separator;
            }
            File file = this.project.resolveFile(stringArray[n]);
            FileSet fileSet = new FileSet();
            fileSet.setDir(file);
            fileSet.setIncludes("*");
            path.addFileset(fileSet);
            ++n;
        }
    }

    public abstract boolean execute() throws BuildException;
}

