/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class SQLExec
extends Task {
    private int goodSql = 0;
    private int totalSql = 0;
    private Path classpath;
    private AntClassLoader loader;
    private Connection conn = null;
    private boolean autocommit = false;
    private Statement statement = null;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector transactions = new Vector();
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private File output = null;
    private String rdbms = null;
    private String version = null;
    private String onError = "abort";

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setSrc(File file) {
        this.srcFile = file;
    }

    public void addText(String string) {
        this.sqlCommand = this.sqlCommand + string;
    }

    public Transaction createTransaction() {
        Transaction transaction = new Transaction();
        this.transactions.addElement(transaction);
        return transaction;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUserid(String string) {
        this.userId = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setAutocommit(boolean bl) {
        this.autocommit = bl;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setPrint(boolean bl) {
        this.print = bl;
    }

    public void setShowheaders(boolean bl) {
        this.showheaders = bl;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setRdbms(String string) {
        this.rdbms = string.toLowerCase();
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase();
    }

    public void setOnerror(OnError onError) {
        this.onError = onError.getValue();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        block40: {
            block39: {
                this.sqlCommand = this.sqlCommand.trim();
                if (this.srcFile == null && this.sqlCommand.length() == 0) {
                    if (this.transactions.size() == 0) {
                        throw new BuildException("Source file, transactions or sql statement must be set!", this.location);
                    }
                } else {
                    var1_1 = this.createTransaction();
                    var1_1.setSrc(this.srcFile);
                    var1_1.addText(this.sqlCommand);
                }
                if (this.driver == null) {
                    throw new BuildException("Driver attribute must be set!", this.location);
                }
                if (this.userId == null) {
                    throw new BuildException("User Id attribute must be set!", this.location);
                }
                if (this.password == null) {
                    throw new BuildException("Password attribute must be set!", this.location);
                }
                if (this.url == null) {
                    throw new BuildException("Url attribute must be set!", this.location);
                }
                if (this.srcFile != null && !this.srcFile.exists()) {
                    throw new BuildException("Source file does not exist!", this.location);
                }
                var1_1 = null;
                try {
                    if (this.classpath != null) {
                        this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                        this.loader = new AntClassLoader(this.project, this.classpath);
                        var2_2 = this.loader.loadClass(this.driver);
                    } else {
                        this.log("Loading " + this.driver + " using system loader.", 3);
                        var2_2 = Class.forName(this.driver);
                    }
                    var1_1 = (Driver)var2_2.newInstance();
                }
                catch (ClassNotFoundException var2_3) {
                    throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (IllegalAccessException var3_5) {
                    throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (InstantiationException var4_9) {
                    throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                try {
                    try {
                        this.log("connecting to " + this.url, 3);
                        var2_2 = new Properties();
                        var2_2.put("user", this.userId);
                        var2_2.put("password", this.password);
                        this.conn = var1_1.connect(this.url, (Properties)var2_2);
                        if (this.conn == null) {
                            throw new SQLException("No suitable Driver for " + this.url);
                        }
                        if (!this.isValidRdbms(this.conn)) {
                            var8_12 = null;
                            break block39;
                        }
                        this.conn.setAutoCommit(this.autocommit);
                        this.statement = this.conn.createStatement();
                        var3_6 = System.out;
                        try {
                            if (this.output != null) {
                                this.log("Opening PrintStream to output file " + this.output, 3);
                                var3_6 = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output)));
                            }
                            var4_10 = this.transactions.elements();
                            while (true) {
                                if (!var4_10.hasMoreElements()) {
                                    var6_18 = null;
                                    if (var3_6 != null && var3_6 != System.out) {
                                        var3_6.close();
                                    }
                                    break block40;
                                }
                                Transaction.access$000((Transaction)var4_10.nextElement(), var3_6);
                                if (this.autocommit) continue;
                                this.log("Commiting transaction", 3);
                                this.conn.commit();
                            }
                        }
                        catch (Throwable var5_20) {
                            var6_19 = null;
                            if (var3_6 == null) throw var5_20;
                            if (var3_6 == System.out) throw var5_20;
                            var3_6.close();
                            throw var5_20;
                        }
                    }
                    catch (IOException var2_4) {
                        if (this.autocommit != false) throw new BuildException(var2_4, this.location);
                        if (this.conn == null) throw new BuildException(var2_4, this.location);
                        if (this.onError.equals("abort") == false) throw new BuildException(var2_4, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException(var2_4, this.location);
                        }
                        catch (SQLException var3_7) {
                            // empty catch block
                        }
                        throw new BuildException(var2_4, this.location);
                    }
                    catch (SQLException var3_8) {
                        if (this.autocommit != false) throw new BuildException(var3_8, this.location);
                        if (this.conn == null) throw new BuildException(var3_8, this.location);
                        if (this.onError.equals("abort") == false) throw new BuildException(var3_8, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException(var3_8, this.location);
                        }
                        catch (SQLException var4_11) {
                            // empty catch block
                        }
                        throw new BuildException(var3_8, this.location);
                    }
                }
                catch (Throwable var7_21) {
                    var8_14 = null;
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                        if (this.conn == null) throw var7_21;
                        this.conn.close();
                        throw var7_21;
                    }
                    catch (SQLException var9_17) {
                        // empty catch block
                    }
                    throw var7_21;
                }
            }
            ** try [egrp 6[TRYBLOCK] [9 : 871->906)] { 
lbl112:
            // 1 sources

            if (this.statement != null) {
                this.statement.close();
            }
            if (this.conn == null) return;
            this.conn.close();
            return;
lbl117:
            // 1 sources

            catch (SQLException var9_15) {
                // empty catch block
            }
            return;
        }
        var8_13 = null;
        try {}
        catch (SQLException var9_16) {}
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.log(this.goodSql + " of " + this.totalSql + " SQL statements executed successfully");
    }

    protected void runStatements(Reader reader, PrintStream printStream) throws SQLException, IOException {
        String string = "";
        String string2 = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).startsWith("//") || string2.startsWith("--") || string2.length() > 2 && string2.substring(0, 3).equalsIgnoreCase("REM")) continue;
            string = string + " " + string2;
            string = string.trim();
            if (string2.indexOf("--") >= 0) {
                string = string + "\n";
            }
            if ((!this.delimiterType.equals("normal") || !string.endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !string2.equals(this.delimiter))) continue;
            this.log("SQL: " + string, 3);
            this.execSQL(string.substring(0, string.length() - this.delimiter.length()), printStream);
            string = "";
        }
        if (!string.equals("")) {
            this.execSQL(string, printStream);
        }
    }

    protected boolean isValidRdbms(Connection connection) {
        if (this.rdbms == null && this.version == null) {
            return true;
        }
        try {
            String string;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (this.rdbms != null) {
                string = databaseMetaData.getDatabaseProductName().toLowerCase();
                this.log("RDBMS = " + string, 3);
                if (string == null || string.indexOf(this.rdbms) < 0) {
                    this.log("Not the required RDBMS: " + this.rdbms, 3);
                    return false;
                }
            }
            if (this.version != null) {
                string = databaseMetaData.getDatabaseProductVersion().toLowerCase();
                this.log("Version = " + string, 3);
                if (string == null || !string.startsWith(this.version) && string.indexOf(" " + this.version) < 0) {
                    this.log("Not the required version: \"" + this.version + "\"", 3);
                    return false;
                }
            }
        }
        catch (SQLException sQLException) {
            this.log("Failed to obtain required RDBMS information", 0);
            return false;
        }
        return true;
    }

    protected void execSQL(String string, PrintStream printStream) throws SQLException {
        if ("".equals(string.trim())) {
            return;
        }
        try {
            ++this.totalSql;
            if (!this.statement.execute(string)) {
                this.log(this.statement.getUpdateCount() + " rows affected", 3);
            } else if (this.print) {
                this.printResults(printStream);
            }
            SQLWarning sQLWarning = this.conn.getWarnings();
            while (sQLWarning != null) {
                this.log(sQLWarning + " sql warning", 3);
                sQLWarning = sQLWarning.getNextWarning();
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException sQLException) {
            this.log("Failed to execute: " + string, 0);
            if (!this.onError.equals("continue")) {
                throw sQLException;
            }
            this.log(sQLException.toString(), 0);
        }
    }

    protected void printResults(PrintStream printStream) throws SQLException {
        ResultSet resultSet = null;
        do {
            int n;
            if ((resultSet = this.statement.getResultSet()) == null) continue;
            this.log("Processing new result set.", 3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            if (this.showheaders) {
                n = 1;
                while (n < n2) {
                    stringBuffer.append(resultSetMetaData.getColumnName(n));
                    stringBuffer.append(",");
                    ++n;
                }
                stringBuffer.append(resultSetMetaData.getColumnName(n2));
                printStream.println(stringBuffer);
                stringBuffer.setLength(0);
            }
            while (resultSet.next()) {
                n = 1;
                int n3 = 1;
                while (n3 <= n2) {
                    String string = resultSet.getString(n3);
                    if (string != null) {
                        string = string.trim();
                    }
                    if (n != 0) {
                        n = 0;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string);
                    ++n3;
                }
                printStream.println(stringBuffer);
                stringBuffer.setLength(0);
            }
        } while (this.statement.getMoreResults());
        printStream.println();
    }

    public class Transaction {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        public void setSrc(File file) {
            this.tSrcFile = file;
        }

        public void addText(String string) {
            this.tSqlCommand = this.tSqlCommand + string;
        }

        private void runTransaction(PrintStream printStream) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), printStream);
            }
            if (this.tSrcFile != null) {
                SQLExec.this.log("Executing file: " + this.tSrcFile.getAbsolutePath(), 2);
                FileReader fileReader = new FileReader(this.tSrcFile);
                SQLExec.this.runStatements(fileReader, printStream);
                fileReader.close();
            }
        }

        static /* synthetic */ void access$000(Transaction transaction, PrintStream printStream) throws IOException, SQLException {
            transaction.runTransaction(printStream);
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }
}

