/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Replace
extends MatchingTask {
    private File src = null;
    private NestedString token = null;
    private NestedString value = new NestedString();
    private File propertyFile = null;
    private Properties properties = null;
    private Vector replacefilters = new Vector();
    private File dir = null;

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.propertyFile != null) {
            this.properties = this.getProperties(this.propertyFile);
        }
        this.validateReplacefilters();
        if (this.src != null) {
            this.processFile(this.src);
        }
        if (this.dir != null) {
            DirectoryScanner directoryScanner = super.getDirectoryScanner(this.dir);
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(this.dir, stringArray[n]);
                this.processFile(file);
                ++n;
            }
        }
    }

    public void validateAttributes() throws BuildException {
        if (this.src == null && this.dir == null) {
            String string = "Either the file or the dir attribute must be specified";
            throw new BuildException(string, this.location);
        }
        if (this.propertyFile != null && !this.propertyFile.exists()) {
            String string = "Property file " + this.propertyFile.getPath() + " does not exist.";
            throw new BuildException(string, this.location);
        }
        if (this.token == null && this.replacefilters.size() == 0) {
            String string = "Either token or a nested replacefilter must be specified";
            throw new BuildException(string, this.location);
        }
        if (this.token != null && "".equals(this.token.getText())) {
            String string = "The token attribute must not be an empty string.";
            throw new BuildException(string, this.location);
        }
    }

    public void validateReplacefilters() throws BuildException {
        int n = 0;
        while (n < this.replacefilters.size()) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(n);
            replacefilter.validate();
            ++n;
        }
    }

    public Properties getProperties(File file) throws BuildException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "Property file (" + file.getPath() + ") not found.";
            throw new BuildException(string);
        }
        catch (IOException iOException) {
            String string = "Property file (" + file.getPath() + ") cannot be loaded.";
            throw new BuildException(string);
        }
        return properties;
    }

    private void processFile(File file) throws BuildException {
        if (!file.exists()) {
            throw new BuildException("Replace: source file " + file.getPath() + " doesn't exist", this.location);
        }
        File file2 = new File(file.getPath() + ".temp");
        if (file2.exists()) {
            throw new BuildException("Replace: temporary file " + file2.getPath() + " already exists", this.location);
        }
        try {
            boolean bl;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            int n = (int)file.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            int n3 = 0;
            while ((n2 = bufferedReader.read()) >= 0) {
                stringBuffer.append((char)n2);
                ++n3;
            }
            String string = stringBuffer.toString();
            String string2 = new String(string);
            if (this.token != null) {
                String string3 = System.getProperty("line.separator");
                String string4 = this.stringReplace(this.value.getText(), "\n", string3);
                String string5 = this.stringReplace(this.token.getText(), "\n", string3);
                this.log("Replacing in " + file.getPath() + ": " + this.token.getText() + " --> " + this.value.getText(), 3);
                string2 = this.stringReplace(string2, string5, string4);
            }
            if (this.replacefilters.size() > 0) {
                string2 = this.processReplacefilters(string2, file.getPath());
            }
            boolean bl2 = bl = !string2.equals(string);
            if (bl) {
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.flush();
            }
            bufferedWriter.close();
            bufferedReader.close();
            if (bl) {
                file.delete();
                file2.renameTo(file);
            } else {
                file2.delete();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new BuildException(iOException, this.location);
        }
    }

    private String processReplacefilters(String string, String string2) {
        String string3 = new String(string);
        int n = 0;
        while (n < this.replacefilters.size()) {
            Replacefilter replacefilter = (Replacefilter)this.replacefilters.elementAt(n);
            this.log("Replacing in " + string2 + ": " + replacefilter.getToken() + " --> " + replacefilter.getReplaceValue(), 3);
            string3 = this.stringReplace(string3, replacefilter.getToken(), replacefilter.getReplaceValue());
            ++n;
        }
        return string3;
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setToken(String string) {
        this.createReplaceToken().addText(string);
    }

    public void setValue(String string) {
        this.createReplaceValue().addText(string);
    }

    public NestedString createReplaceToken() {
        if (this.token == null) {
            this.token = new NestedString();
        }
        return this.token;
    }

    public NestedString createReplaceValue() {
        return this.value;
    }

    public void setPropertyFile(File file) {
        this.propertyFile = file;
    }

    public Replacefilter createReplacefilter() {
        Replacefilter replacefilter = new Replacefilter();
        this.replacefilters.addElement(replacefilter);
        return replacefilter;
    }

    private String stringReplace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (string.length() > n) {
            stringBuffer.append(string.substring(n, string.length()));
        }
        return stringBuffer.toString();
    }

    public class Replacefilter {
        private String token;
        private String value;
        private String property;

        public void validate() throws BuildException {
            if (this.token == null) {
                String string = "token is a mandatory attribute of replacefilter.";
                throw new BuildException(string);
            }
            if ("".equals(this.token)) {
                String string = "The token attribute must not be an empty string.";
                throw new BuildException(string);
            }
            if (this.value != null && this.property != null) {
                String string = "Either value or property can be specified, but a replacefilter element cannot have both.";
                throw new BuildException(string);
            }
            if (this.property != null) {
                if (Replace.this.propertyFile == null) {
                    String string = "The replacefilter's property attribute can only be used with the replacetask's propertyFile attribute.";
                    throw new BuildException(string);
                }
                if (Replace.this.properties == null || Replace.this.properties.getProperty(this.property) == null) {
                    String string = "property \"" + this.property + "\" was not found in " + Replace.this.propertyFile.getPath();
                    throw new BuildException(string);
                }
            }
        }

        public String getReplaceValue() {
            if (this.property != null) {
                return Replace.this.properties.getProperty(this.property);
            }
            if (this.value != null) {
                return this.value;
            }
            if (Replace.this.value != null) {
                return Replace.this.value.getText();
            }
            return new String("");
        }

        public void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public String getProperty() {
            return this.property;
        }
    }

    public class NestedString {
        private StringBuffer buf = new StringBuffer();

        public void addText(String string) {
            this.buf.append(string);
        }

        public String getText() {
            return this.buf.toString();
        }
    }
}

