/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private File manifest;
    private boolean manifestAdded;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
    }

    public void setJarfile(File file) {
        super.setZipfile(file);
    }

    public void setManifest(File file) {
        this.manifest = file;
        if (!this.manifest.exists()) {
            throw new BuildException("Manifest file: " + this.manifest + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(new File(this.manifest.getParent()));
        zipFileSet.setIncludes(this.manifest.getName());
        zipFileSet.setFullpath("META-INF/MANIFEST.MF");
        super.addFileset(zipFileSet);
    }

    public void addMetainf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("META-INF/");
        super.addFileset(zipFileSet);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.manifest == null) {
            String string = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                throw new BuildException("Could not find: " + string);
            }
            this.zipDir(null, zipOutputStream, "META-INF/");
            this.zipFile(inputStream, zipOutputStream, "META-INF/MANIFEST.MF", System.currentTimeMillis());
        }
        super.initZipOutputStream(zipOutputStream);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            if (this.manifest == null || !this.manifest.equals(file) || this.manifestAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a META-INF/MANIFEST.MF which will be ignored " + "(please use manifest attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zipOutputStream, string);
                this.manifestAdded = true;
            }
        } else {
            super.zipFile(file, zipOutputStream, string);
        }
    }

    protected void cleanUp() {
        this.manifestAdded = false;
        super.cleanUp();
    }
}

