/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private boolean parallel = false;
    protected String type = "file";
    protected Commandline.Marker srcFilePos = null;
    private boolean skipEmpty = false;
    protected Commandline.Marker targetFilePos = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper mapper = null;
    protected File destDir = null;
    protected boolean srcIsFirst = true;

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setParallel(boolean bl) {
        this.parallel = bl;
    }

    public void setType(FileDirBoth fileDirBoth) {
        this.type = fileDirBoth.getValue();
    }

    public void setSkipEmptyFilesets(boolean bl) {
        this.skipEmpty = bl;
    }

    public void setDest(File file) {
        this.destDir = file;
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(this.taskType + " doesn't support multiple srcfile elements.", this.location);
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.taskType + " doesn't support multiple targetfile elements.", this.location);
        }
        this.targetFilePos = this.cmdl.createMarker();
        this.srcIsFirst = this.srcFilePos != null;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    protected void checkConfiguration() {
        if ("execon".equals(this.taskName)) {
            this.log("!! execon is deprecated. Use apply instead. !!");
        }
        super.checkConfiguration();
        if (this.filesets.size() == 0) {
            throw new BuildException("no filesets specified", this.location);
        }
        if (this.targetFilePos != null || this.mapperElement != null || this.destDir != null) {
            if (this.mapperElement == null) {
                throw new BuildException("no mapper specified", this.location);
            }
            if (this.mapperElement == null) {
                throw new BuildException("no dest attribute specified", this.location);
            }
            this.mapper = this.mapperElement.getImplementation();
        }
    }

    protected void runExec(Execute execute) throws BuildException {
        try {
            block13: {
                try {
                    String[] stringArray;
                    Object[] objectArray;
                    Object[] objectArray2;
                    Vector<Object> vector = new Vector<Object>();
                    Vector<Object[]> vector2 = new Vector<Object[]>();
                    int n = 0;
                    while (n < this.filesets.size()) {
                        int n2;
                        Object[] objectArray3;
                        objectArray2 = (Object[])this.filesets.elementAt(n);
                        objectArray = objectArray2.getDir(this.project);
                        stringArray = objectArray2.getDirectoryScanner(this.project);
                        if (!"dir".equals(this.type)) {
                            objectArray3 = this.getFiles((File)objectArray, (DirectoryScanner)stringArray);
                            n2 = 0;
                            while (n2 < objectArray3.length) {
                                vector.addElement(objectArray3[n2]);
                                vector2.addElement(objectArray);
                                ++n2;
                            }
                        }
                        if (!"file".equals(this.type)) {
                            objectArray3 = this.getDirs((File)objectArray, (DirectoryScanner)stringArray);
                            n2 = 0;
                            while (n2 < objectArray3.length) {
                                vector.addElement(objectArray3[n2]);
                                vector2.addElement(objectArray);
                                ++n2;
                            }
                        }
                        if (vector.size() == 0 && this.skipEmpty) {
                            this.log("Skipping fileset for directory " + objectArray + ". It is empty.", 2);
                        } else if (!this.parallel) {
                            objectArray3 = new String[vector.size()];
                            vector.copyInto(objectArray3);
                            n2 = 0;
                            while (n2 < objectArray3.length) {
                                String[] stringArray2 = this.getCommandline((String)objectArray3[n2], (File)objectArray);
                                this.log("Executing " + Commandline.toString(stringArray2), 3);
                                execute.setCommandline(stringArray2);
                                this.runExecute(execute);
                                ++n2;
                            }
                            vector.removeAllElements();
                            vector2.removeAllElements();
                        }
                        ++n;
                    }
                    if (!this.parallel) break block13;
                    objectArray2 = new String[vector.size()];
                    vector.copyInto(objectArray2);
                    objectArray = new File[vector2.size()];
                    vector2.copyInto(objectArray);
                    stringArray = this.getCommandline((String[])objectArray2, (File[])objectArray);
                    this.log("Executing " + Commandline.toString(stringArray), 3);
                    execute.setCommandline(stringArray);
                    this.runExecute(execute);
                }
                catch (IOException iOException) {
                    throw new BuildException("Execute failed: " + iOException, iOException, this.location);
                }
            }
            Object var12_12 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.logFlush();
            throw throwable;
        }
    }

    protected String[] getCommandline(String[] stringArray, File[] fileArray) {
        int n;
        String[] stringArray2;
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        if (this.targetFilePos != null) {
            objectArray = new Hashtable();
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray2 = this.mapper.mapFileName(stringArray[n2]);
                if (stringArray2 != null) {
                    n = 0;
                    while (n < stringArray2.length) {
                        String string = new File(this.destDir, stringArray2[n]).getAbsolutePath();
                        if (!objectArray.contains(string)) {
                            vector.addElement(string);
                            objectArray.put(string, string);
                        }
                        ++n;
                    }
                }
                ++n2;
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        String[] stringArray3 = this.cmdl.getCommandline();
        stringArray2 = new String[stringArray3.length + stringArray.length + objectArray.length];
        n = stringArray3.length;
        if (this.srcFilePos != null) {
            n = this.srcFilePos.getPosition();
        }
        if (this.targetFilePos != null) {
            int n3 = this.targetFilePos.getPosition();
            if (n < n3 || n == n3 && this.srcIsFirst) {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length, n3 - n);
                System.arraycopy(objectArray, 0, stringArray2, n3 + stringArray.length, objectArray.length);
                System.arraycopy(stringArray3, n3, stringArray2, n3 + stringArray.length + objectArray.length, stringArray3.length - n3);
            } else {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n3);
                System.arraycopy(objectArray, 0, stringArray2, n3, objectArray.length);
                System.arraycopy(stringArray3, n3, stringArray2, n3 + objectArray.length, n - n3);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length + objectArray.length, stringArray3.length - n);
                n += objectArray.length;
            }
        } else {
            System.arraycopy(stringArray3, 0, stringArray2, 0, n);
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            stringArray2[n + n4] = new File(fileArray[n4], stringArray[n4]).getAbsolutePath();
            ++n4;
        }
        return stringArray2;
    }

    protected String[] getCommandline(String string, File file) {
        return this.getCommandline(new String[]{string}, new File[]{file});
    }

    protected String[] getFiles(File file, DirectoryScanner directoryScanner) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(directoryScanner.getIncludedFiles(), file, this.destDir, this.mapper);
        }
        return directoryScanner.getIncludedFiles();
    }

    protected String[] getDirs(File file, DirectoryScanner directoryScanner) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(directoryScanner.getIncludedDirectories(), file, this.destDir, this.mapper);
        }
        return directoryScanner.getIncludedDirectories();
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }
}

