/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Available
extends Task {
    private String property;
    private String classname;
    private File file;
    private Path filepath;
    private String resource;
    private String type;
    private Path classpath;
    private AntClassLoader loader;
    private String value = "true";

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setFilepath(Path path) {
        this.createFilepath().append(path);
    }

    public Path createFilepath() {
        if (this.filepath == null) {
            this.filepath = new Path(this.project);
        }
        return this.filepath.createPath();
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setClassname(String string) {
        if (!"".equals(string)) {
            this.classname = string;
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required", this.location);
        }
        if (this.classname == null && this.file == null && this.resource == null) {
            throw new BuildException("At least one of (classname|file|resource) is required", this.location);
        }
        if (this.type != null && !this.type.equalsIgnoreCase("file") && !this.type.equalsIgnoreCase("dir")) {
            throw new BuildException("Type must be one of either dir or file");
        }
        if (this.classpath != null) {
            this.loader = new AntClassLoader(this.project, this.classpath);
        }
        if (this.classname != null && !this.checkClass(this.classname)) {
            this.log("Unable to load class " + this.classname + " to set property " + this.property, 3);
            return;
        }
        if (this.file != null && !this.checkFile()) {
            this.log("Unable to find " + this.file + " to set property " + this.property, 3);
            return;
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            this.log("Unable to load resource " + this.resource + " to set property " + this.property, 3);
            return;
        }
        this.project.setProperty(this.property, this.value);
        if (this.loader != null) {
            this.loader.cleanup();
        }
    }

    private boolean checkFile() {
        if (this.filepath == null) {
            return this.checkFile(this.file);
        }
        String[] stringArray = this.filepath.list();
        int n = 0;
        while (n < stringArray.length) {
            this.log("Searching " + stringArray[n], 3);
            if (new File(stringArray[n], this.file.getName()).isFile()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean checkFile(File file) {
        if (this.type != null) {
            if (this.type.equalsIgnoreCase("dir")) {
                return file.isDirectory();
            }
            if (this.type.equalsIgnoreCase("file")) {
                return file.isFile();
            }
        }
        return file.exists();
    }

    private boolean checkResource(String string) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(string) != null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(string) != null;
        }
        return ClassLoader.getSystemResourceAsStream(string) != null;
    }

    private boolean checkClass(String string) {
        try {
            if (this.loader != null) {
                this.loader.loadClass(string);
            } else {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader != null) {
                    classLoader.loadClass(string);
                } else {
                    Class.forName(string);
                }
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }
}

