/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;

public class Target
implements TaskContainer {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private Vector dependencies = new Vector(2);
    private Vector children = new Vector(5);
    private Project project;
    private String description = null;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setDepends(String string) {
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.addDependency(stringTokenizer.nextToken().trim());
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addTask(Task task) {
        this.children.addElement(task);
    }

    public void addDataType(RuntimeConfigurable runtimeConfigurable) {
        this.children.addElement(runtimeConfigurable);
    }

    public Task[] getTasks() {
        Object object;
        Vector vector = new Vector(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof Task)) continue;
            vector.addElement(object);
        }
        object = new Task[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void addDependency(String string) {
        this.dependencies.addElement(string);
    }

    public Enumeration getDependencies() {
        return this.dependencies.elements();
    }

    public void setIf(String string) {
        this.ifCondition = string == null ? "" : string;
    }

    public void setUnless(String string) {
        this.unlessCondition = string == null ? "" : string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object e = enumeration.nextElement();
                if (e instanceof Task) {
                    object = (Task)e;
                    ((Task)object).perform();
                    continue;
                }
                object = (RuntimeConfigurable)e;
                ((RuntimeConfigurable)object).maybeConfigure(this.project);
            }
        } else if (!this.testIfCondition()) {
            this.project.log(this, "Skipped because property '" + this.ifCondition + "' not set.", 3);
        } else {
            this.project.log(this, "Skipped because property '" + this.unlessCondition + "' set.", 3);
        }
    }

    public final void performTasks() {
        try {
            this.project.fireTargetStarted(this);
            this.execute();
            this.project.fireTargetFinished(this, null);
        }
        catch (RuntimeException runtimeException) {
            this.project.fireTargetFinished(this, runtimeException);
            throw runtimeException;
        }
    }

    void replaceTask(UnknownElement unknownElement, Task task) {
        int n = -1;
        while ((n = this.children.indexOf(unknownElement)) >= 0) {
            this.children.setElementAt(task, n);
        }
    }

    private boolean testIfCondition() {
        return "".equals(this.ifCondition) || this.project.getProperty(this.ifCondition) != null;
    }

    private boolean testUnlessCondition() {
        return "".equals(this.unlessCondition) || this.project.getProperty(this.unlessCondition) == null;
    }
}

