/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProjectHelper {
    private static SAXParserFactory parserFactory = null;
    private Parser parser;
    private Project project;
    private File buildFile;
    private File buildFileParent;
    private Locator locator;

    public static void configureProject(Project project, File file) throws BuildException {
        new ProjectHelper(project, file).parse();
    }

    private ProjectHelper(Project project, File file) {
        this.project = project;
        this.buildFile = new File(file.getAbsolutePath());
        this.buildFileParent = new File(this.buildFile.getParent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse() throws BuildException {
        FileInputStream fileInputStream = null;
        InputSource inputSource = null;
        try {
            try {
                SAXParser sAXParser = ProjectHelper.getParserFactory().newSAXParser();
                this.parser = sAXParser.getParser();
                String string = "file:" + this.buildFile.getAbsolutePath().replace('\\', '/');
                int n = string.indexOf(35);
                while (true) {
                    if (n == -1) {
                        fileInputStream = new FileInputStream(this.buildFile);
                        inputSource = new InputSource(fileInputStream);
                        inputSource.setSystemId(string);
                        this.project.log("parsing buildfile " + this.buildFile + " with URI = " + string, 3);
                        sAXParser.parse(inputSource, (HandlerBase)new RootHandler());
                        break;
                    }
                    string = string.substring(0, n) + "%23" + string.substring(n + 1);
                    n = string.indexOf(35);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new BuildException("Parser has not been configured correctly", parserConfigurationException);
            }
            catch (SAXParseException sAXParseException) {
                Location location = new Location(this.buildFile.toString(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
                Exception exception = sAXParseException.getException();
                if (!(exception instanceof BuildException)) throw new BuildException(sAXParseException.getMessage(), exception, location);
                BuildException buildException = (BuildException)exception;
                if (buildException.getLocation() != Location.UNKNOWN_LOCATION) throw buildException;
                buildException.setLocation(location);
                throw buildException;
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (!(exception instanceof BuildException)) throw new BuildException(sAXException.getMessage(), exception);
                throw (BuildException)exception;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BuildException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new BuildException("Error reading project file", iOException);
            }
            Object var9_10 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }

    public static void configure(Object object, AttributeList attributeList, Project project) throws BuildException {
        if (object instanceof TaskAdapter) {
            object = ((TaskAdapter)object).getProxy();
        }
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(object.getClass());
        project.addBuildListener(introspectionHelper);
        int n = 0;
        while (n < attributeList.getLength()) {
            block4: {
                String string = ProjectHelper.replaceProperties(project, attributeList.getValue(n), project.getProperties());
                try {
                    introspectionHelper.setAttribute(project, object, attributeList.getName(n).toLowerCase(), string);
                }
                catch (BuildException buildException) {
                    if (attributeList.getName(n).equals("id")) break block4;
                    throw buildException;
                }
            }
            ++n;
        }
    }

    public static void addText(Project project, Object object, char[] cArray, int n, int n2) throws BuildException {
        ProjectHelper.addText(project, object, new String(cArray, n, n2));
    }

    public static void addText(Project project, Object object, String string) throws BuildException {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (object instanceof TaskAdapter) {
            object = ((TaskAdapter)object).getProxy();
        }
        IntrospectionHelper.getHelper(object.getClass()).addText(project, object, string);
    }

    public static String replaceProperties(Project project, String string, Hashtable hashtable) throws BuildException {
        if (string == null) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        ProjectHelper.parsePropertyString(string, vector, vector2);
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null) {
                String string3 = (String)enumeration2.nextElement();
                if (!hashtable.containsKey(string3)) {
                    project.log("Property ${" + string3 + "} has not been set", 3);
                }
                string2 = hashtable.containsKey(string3) ? (String)hashtable.get(string3) : "${" + string3 + "}";
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void parsePropertyString(String string, Vector vector, Vector vector2) throws BuildException {
        int n;
        int n2 = 0;
        while ((n = string.indexOf("$", n2)) >= 0) {
            if (n > 0) {
                vector.addElement(string.substring(n2, n));
            }
            if (n == string.length() - 1) {
                vector.addElement("$");
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n + 1) != '{') {
                vector.addElement(string.substring(n + 1, n + 2));
                n2 = n + 2;
                continue;
            }
            int n3 = string.indexOf(125, n);
            if (n3 < 0) {
                throw new BuildException("Syntax error in property: " + string);
            }
            String string2 = string.substring(n + 2, n3);
            vector.addElement(null);
            vector2.addElement(string2);
            n2 = n3 + 1;
        }
        if (n2 < string.length()) {
            vector.addElement(string.substring(n2));
        }
    }

    private static SAXParserFactory getParserFactory() {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
        }
        return parserFactory;
    }

    private void configureId(Object object, AttributeList attributeList) {
        String string = attributeList.getValue("id");
        if (string != null) {
            this.project.addReference(string, object);
        }
    }

    private class DataTypeHandler
    extends AbstractHandler {
        private Target target;
        private Object element;
        private RuntimeConfigurable wrapper = null;

        public DataTypeHandler(DocumentHandler documentHandler) {
            this(documentHandler, null);
        }

        public DataTypeHandler(DocumentHandler documentHandler, Target target) {
            super(documentHandler);
            this.target = target;
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            try {
                this.element = ProjectHelper.this.project.createDataType(string);
                if (this.element == null) {
                    throw new BuildException("Unknown data type " + string);
                }
                if (this.target != null) {
                    this.wrapper = new RuntimeConfigurable(this.element);
                    this.wrapper.setAttributes(attributeList);
                    this.target.addDataType(this.wrapper);
                } else {
                    ProjectHelper.configure(this.element, attributeList, ProjectHelper.this.project);
                    ProjectHelper.this.configureId(this.element, attributeList);
                }
            }
            catch (BuildException buildException) {
                throw new SAXParseException(buildException.getMessage(), ProjectHelper.this.locator, buildException);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXParseException {
            try {
                ProjectHelper.addText(ProjectHelper.this.project, this.element, cArray, n, n2);
            }
            catch (BuildException buildException) {
                throw new SAXParseException(buildException.getMessage(), ProjectHelper.this.locator, buildException);
            }
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            new NestedElementHandler(this, this.element, this.wrapper, this.target).init(string, attributeList);
        }
    }

    private class NestedElementHandler
    extends AbstractHandler {
        private Object parent;
        private Object child;
        private RuntimeConfigurable parentWrapper;
        private RuntimeConfigurable childWrapper = null;
        private Target target;

        public NestedElementHandler(DocumentHandler documentHandler, Object object, RuntimeConfigurable runtimeConfigurable, Target target) {
            super(documentHandler);
            this.parent = object instanceof TaskAdapter ? ((TaskAdapter)object).getProxy() : object;
            this.parentWrapper = runtimeConfigurable;
            this.target = target;
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            Class<?> clazz = this.parent.getClass();
            IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(clazz);
            try {
                if (this.parent instanceof UnknownElement) {
                    this.child = new UnknownElement(string.toLowerCase());
                    ((UnknownElement)this.parent).addChild((UnknownElement)this.child);
                } else {
                    this.child = introspectionHelper.createElement(ProjectHelper.this.project, this.parent, string.toLowerCase());
                }
                ProjectHelper.this.configureId(this.child, attributeList);
                if (this.parentWrapper != null) {
                    this.childWrapper = new RuntimeConfigurable(this.child);
                    this.childWrapper.setAttributes(attributeList);
                    this.parentWrapper.addChild(this.childWrapper);
                } else {
                    ProjectHelper.configure(this.child, attributeList, ProjectHelper.this.project);
                }
            }
            catch (BuildException buildException) {
                throw new SAXParseException(buildException.getMessage(), ProjectHelper.this.locator, buildException);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXParseException {
            if (this.parentWrapper == null) {
                try {
                    ProjectHelper.addText(ProjectHelper.this.project, this.child, cArray, n, n2);
                }
                catch (BuildException buildException) {
                    throw new SAXParseException(buildException.getMessage(), ProjectHelper.this.locator, buildException);
                }
            } else {
                this.childWrapper.addText(cArray, n, n2);
            }
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (this.child instanceof TaskContainer) {
                new TaskHandler(this, (TaskContainer)this.child, this.target).init(string, attributeList);
            } else {
                new NestedElementHandler(this, this.child, this.childWrapper, this.target).init(string, attributeList);
            }
        }
    }

    private class TaskHandler
    extends AbstractHandler {
        private Target target;
        private TaskContainer container;
        private Task task;
        private RuntimeConfigurable wrapper = null;

        public TaskHandler(DocumentHandler documentHandler, TaskContainer taskContainer, Target target) {
            super(documentHandler);
            this.container = taskContainer;
            this.target = target;
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            try {
                this.task = ProjectHelper.this.project.createTask(string);
            }
            catch (BuildException buildException) {
                // empty catch block
            }
            if (this.task == null) {
                this.task = new UnknownElement(string);
                this.task.setProject(ProjectHelper.this.project);
            }
            this.task.setLocation(new Location(ProjectHelper.this.buildFile.toString(), ProjectHelper.this.locator.getLineNumber(), ProjectHelper.this.locator.getColumnNumber()));
            ProjectHelper.this.configureId(this.task, attributeList);
            if (this.target != null) {
                this.task.setOwningTarget(this.target);
                this.container.addTask(this.task);
                this.task.init();
                this.wrapper = this.task.getRuntimeConfigurableWrapper();
                this.wrapper.setAttributes(attributeList);
            } else {
                this.task.init();
                ProjectHelper.configure(this.task, attributeList, ProjectHelper.this.project);
            }
        }

        protected void finished() {
            if (this.task != null && this.target == null) {
                this.task.execute();
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXParseException {
            if (this.wrapper == null) {
                try {
                    ProjectHelper.addText(ProjectHelper.this.project, this.task, cArray, n, n2);
                }
                catch (BuildException buildException) {
                    throw new SAXParseException(buildException.getMessage(), ProjectHelper.this.locator, buildException);
                }
            } else {
                this.wrapper.addText(cArray, n, n2);
            }
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (this.task instanceof TaskContainer) {
                new TaskHandler(this, (TaskContainer)((Object)this.task), this.target).init(string, attributeList);
            } else {
                new NestedElementHandler(this, this.task, this.wrapper, this.target).init(string, attributeList);
            }
        }
    }

    private class TargetHandler
    extends AbstractHandler {
        private Target target;

        public TargetHandler(DocumentHandler documentHandler) {
            super(documentHandler);
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            Object object;
            String string2 = null;
            String string3 = "";
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            int n = 0;
            while (n < attributeList.getLength()) {
                object = attributeList.getName(n);
                String string8 = attributeList.getValue(n);
                if (((String)object).equals("name")) {
                    string2 = string8;
                } else if (((String)object).equals("depends")) {
                    string3 = string8;
                } else if (((String)object).equals("if")) {
                    string4 = string8;
                } else if (((String)object).equals("unless")) {
                    string5 = string8;
                } else if (((String)object).equals("id")) {
                    string6 = string8;
                } else if (((String)object).equals("description")) {
                    string7 = string8;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + (String)object + "\"", ProjectHelper.this.locator);
                }
                ++n;
            }
            if (string2 == null) {
                throw new SAXParseException("target element appears without a name attribute", ProjectHelper.this.locator);
            }
            this.target = new Target();
            this.target.setName(string2);
            this.target.setIf(string4);
            this.target.setUnless(string5);
            this.target.setDescription(string7);
            ProjectHelper.this.project.addTarget(string2, this.target);
            if (string6 != null && !string6.equals("")) {
                ProjectHelper.this.project.addReference(string6, this.target);
            }
            if (string3.length() > 0) {
                object = new StringTokenizer(string3, ",", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.target.addDependency(((StringTokenizer)object).nextToken().trim());
                }
            }
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (ProjectHelper.this.project.getDataTypeDefinitions().get(string) != null) {
                new DataTypeHandler(this, this.target).init(string, attributeList);
            } else {
                new TaskHandler(this, this.target, this.target).init(string, attributeList);
            }
        }
    }

    private class ProjectHandler
    extends AbstractHandler {
        public ProjectHandler(DocumentHandler documentHandler) {
            super(documentHandler);
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = 0;
            while (n < attributeList.getLength()) {
                String string6 = attributeList.getName(n);
                String string7 = attributeList.getValue(n);
                if (string6.equals("default")) {
                    string2 = string7;
                } else if (string6.equals("name")) {
                    string3 = string7;
                } else if (string6.equals("id")) {
                    string4 = string7;
                } else if (string6.equals("basedir")) {
                    string5 = string7;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + attributeList.getName(n) + "\"", ProjectHelper.this.locator);
                }
                ++n;
            }
            if (string2 == null) {
                throw new SAXParseException("The default attribute of project is required", ProjectHelper.this.locator);
            }
            ProjectHelper.this.project.setDefaultTarget(string2);
            if (string3 != null) {
                ProjectHelper.this.project.setName(string3);
                ProjectHelper.this.project.addReference(string3, ProjectHelper.this.project);
            }
            if (string4 != null) {
                ProjectHelper.this.project.addReference(string4, ProjectHelper.this.project);
            }
            if (ProjectHelper.this.project.getProperty("basedir") != null) {
                ProjectHelper.this.project.setBasedir(ProjectHelper.this.project.getProperty("basedir"));
            } else if (string5 == null) {
                ProjectHelper.this.project.setBasedir(ProjectHelper.this.buildFileParent.getAbsolutePath());
            } else if (new File(string5).isAbsolute()) {
                ProjectHelper.this.project.setBasedir(string5);
            } else {
                ProjectHelper.this.project.setBaseDir(ProjectHelper.this.project.resolveFile(string5, ProjectHelper.this.buildFileParent));
            }
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (string.equals("taskdef")) {
                this.handleTaskdef(string, attributeList);
            } else if (string.equals("property")) {
                this.handleProperty(string, attributeList);
            } else if (string.equals("target")) {
                this.handleTarget(string, attributeList);
            } else if (ProjectHelper.this.project.getDataTypeDefinitions().get(string) != null) {
                this.handleDataType(string, attributeList);
            } else {
                throw new SAXParseException("Unexpected element \"" + string + "\"", ProjectHelper.this.locator);
            }
        }

        private void handleTaskdef(String string, AttributeList attributeList) throws SAXParseException {
            new TaskHandler(this, null, null).init(string, attributeList);
        }

        private void handleProperty(String string, AttributeList attributeList) throws SAXParseException {
            new TaskHandler(this, null, null).init(string, attributeList);
        }

        private void handleTarget(String string, AttributeList attributeList) throws SAXParseException {
            new TargetHandler(this).init(string, attributeList);
        }

        private void handleDataType(String string, AttributeList attributeList) throws SAXParseException {
            new DataTypeHandler(this).init(string, attributeList);
        }
    }

    private class RootHandler
    extends HandlerBase {
        private RootHandler() {
        }

        public InputSource resolveEntity(String string, String string2) {
            ProjectHelper.this.project.log("resolving systemId: " + string2, 3);
            if (string2.startsWith("file:")) {
                String string3 = string2.substring(5);
                int n = string3.indexOf("file:");
                while (n != -1) {
                    string3 = string3.substring(0, n) + string3.substring(n + 5);
                    n = string3.indexOf("file:");
                }
                String string4 = string3;
                n = string3.indexOf("%23");
                while (n != -1) {
                    string3 = string3.substring(0, n) + "#" + string3.substring(n + 3);
                    n = string3.indexOf("%23");
                }
                File file = new File(string3);
                if (!file.isAbsolute()) {
                    file = new File(ProjectHelper.this.buildFileParent, string3);
                }
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId("file:" + string4);
                    return inputSource;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ProjectHelper.this.project.log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            return null;
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (!string.equals("project")) {
                throw new SAXParseException("Config file is not of expected XML type", ProjectHelper.this.locator);
            }
            new ProjectHandler(this).init(string, attributeList);
        }

        public void setDocumentLocator(Locator locator) {
            ProjectHelper.this.locator = locator;
        }
    }

    private class AbstractHandler
    extends HandlerBase {
        protected DocumentHandler parentHandler;

        public AbstractHandler(DocumentHandler documentHandler) {
            this.parentHandler = documentHandler;
            ProjectHelper.this.parser.setDocumentHandler(this);
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + string + "\"", ProjectHelper.this.locator);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXParseException {
            String string = new String(cArray, n, n2).trim();
            if (string.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + string + "\"", ProjectHelper.this.locator);
            }
        }

        protected void finished() {
        }

        public void endElement(String string) throws SAXException {
            this.finished();
            ProjectHelper.this.parser.setDocumentHandler(this.parentHandler);
        }
    }
}

