/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;

public class Main {
    public static final String DEFAULT_BUILD_FILENAME = "build.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private Vector targets = new Vector(5);
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(5);
    private String loggerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static String antVersion = null;
    static /* synthetic */ Class class$org$apache$tools$ant$Main;

    private static void printMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string != null) {
            System.err.println(string);
        }
    }

    public static void start(String[] stringArray, Properties properties, ClassLoader classLoader) {
        Main main = null;
        try {
            main = new Main(stringArray);
        }
        catch (Throwable throwable) {
            Main.printMessage(throwable);
            System.exit(1);
        }
        if (properties != null) {
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                ((Hashtable)main.definedProps).put(string, string2);
            }
        }
        try {
            main.runBuild(classLoader);
            System.exit(0);
        }
        catch (BuildException buildException) {
            if (main.err != System.err) {
                Main.printMessage(buildException);
            }
            System.exit(1);
        }
        catch (Throwable throwable) {
            Main.printMessage(throwable);
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        Main.start(stringArray, null, null);
    }

    protected Main(String[] stringArray) throws BuildException {
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            Object object;
            String string3 = stringArray[n];
            if (string3.equals("-help")) {
                Main.printUsage();
                return;
            }
            if (string3.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (string3.equals("-quiet") || string3.equals("-q")) {
                this.msgOutputLevel = 1;
            } else if (string3.equals("-verbose") || string3.equals("-v")) {
                Main.printVersion();
                this.msgOutputLevel = 3;
            } else if (string3.equals("-debug")) {
                Main.printVersion();
                this.msgOutputLevel = 4;
            } else if (string3.equals("-logfile") || string3.equals("-l")) {
                try {
                    object = new File(stringArray[n + 1]);
                    ++n;
                    this.err = this.out = new PrintStream(new FileOutputStream((File)object));
                    System.setOut(this.out);
                    System.setErr(this.out);
                }
                catch (IOException iOException) {
                    string2 = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    System.out.println(string2);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    String string4 = "You must specify a log file when using the -log argument";
                    System.out.println(string4);
                    return;
                }
            } else if (string3.equals("-buildfile") || string3.equals("-file") || string3.equals("-f")) {
                try {
                    this.buildFile = new File(stringArray[n + 1]);
                    ++n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    string2 = "You must specify a buildfile when using the -buildfile argument";
                    System.out.println(string2);
                    return;
                }
            } else if (string3.equals("-listener")) {
                try {
                    this.listeners.addElement(stringArray[n + 1]);
                    ++n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    string2 = "You must specify a classname when using the -listener argument";
                    System.out.println(string2);
                    return;
                }
            } else if (string3.startsWith("-D")) {
                object = string3.substring(2, string3.length());
                string2 = null;
                int n2 = ((String)object).indexOf("=");
                if (n2 > 0) {
                    string2 = ((String)object).substring(n2 + 1);
                    object = ((String)object).substring(0, n2);
                } else if (n < stringArray.length - 1) {
                    string2 = stringArray[++n];
                }
                ((Hashtable)this.definedProps).put(object, string2);
            } else if (string3.equals("-logger")) {
                if (this.loggerClassname != null) {
                    System.out.println("Only one logger class may be specified.");
                    return;
                }
                try {
                    this.loggerClassname = stringArray[++n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("You must specify a classname when using the -logger argument");
                    return;
                }
            } else if (string3.equals("-emacs")) {
                this.emacsMode = true;
            } else if (string3.equals("-projecthelp")) {
                this.projectHelp = true;
            } else if (string3.equals("-find")) {
                string = n < stringArray.length - 1 ? stringArray[++n] : DEFAULT_BUILD_FILENAME;
            } else {
                if (string3.startsWith("-")) {
                    object = "Unknown argument: " + string3;
                    System.out.println((String)object);
                    Main.printUsage();
                    return;
                }
                this.targets.addElement(string3);
            }
            ++n;
        }
        if (this.buildFile == null) {
            this.buildFile = string != null ? this.findBuildFile(System.getProperty("user.dir"), string) : new File(DEFAULT_BUILD_FILENAME);
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        this.readyToRun = true;
    }

    private File getParentFile(File file) {
        String string = file.getAbsolutePath();
        file = new File(string);
        if ((string = file.getParent()) != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + string);
        }
        return string == null ? null : new File(string);
    }

    private File findBuildFile(String string, String string2) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + string2 + " ...");
        }
        File file = new File(new File(string).getAbsolutePath());
        File file2 = new File(file, string2);
        while (!file2.exists()) {
            if ((file = this.getParentFile(file)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file2 = new File(file, string2);
        }
        return file2;
    }

    private void runBuild(ClassLoader classLoader) throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        Project project = new Project();
        project.setSystemLoader(classLoader);
        Throwable throwable = null;
        try {
            block16: {
                try {
                    this.addBuildListeners(project);
                    PrintStream printStream = System.err;
                    PrintStream printStream2 = System.out;
                    SecurityManager securityManager = System.getSecurityManager();
                    try {
                        System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
                        System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
                        project.fireBuildStarted();
                        project.init();
                        project.setUserProperty("ant.version", Main.getAntVersion());
                        Enumeration enumeration = ((Hashtable)this.definedProps).keys();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            String string2 = (String)((Hashtable)this.definedProps).get(string);
                            project.setUserProperty(string, string2);
                        }
                        project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                        try {
                            Class.forName("javax.xml.parsers.SAXParserFactory");
                            ProjectHelper.configureProject(project, this.buildFile);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", noClassDefFoundError);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", classNotFoundException);
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new BuildException("No JAXP compliant XML parser found. See http://java.sun.com/xml for the\nreference implementation.", nullPointerException);
                        }
                        if (this.targets.size() == 0) {
                            this.targets.addElement(project.getDefaultTarget());
                        }
                        if (!this.projectHelp) {
                            project.executeTargets(this.targets);
                        }
                        Object var12_15 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var12_16 = null;
                        System.setOut(printStream2);
                        System.setErr(printStream);
                        throw throwable2;
                    }
                    System.setOut(printStream2);
                    System.setErr(printStream);
                    if (!this.projectHelp) break block16;
                    Main.printTargets(project);
                }
                catch (RuntimeException runtimeException) {
                    throwable = runtimeException;
                    throw runtimeException;
                }
                catch (Error error) {
                    throwable = error;
                    throw error;
                }
            }
            Object var14_18 = null;
            project.fireBuildFinished(throwable);
        }
        catch (Throwable throwable3) {
            Object var14_19 = null;
            project.fireBuildFinished(throwable);
            throw throwable3;
        }
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createLogger());
        int n = 0;
        while (n < this.listeners.size()) {
            String string = (String)this.listeners.elementAt(n);
            try {
                BuildListener buildListener = (BuildListener)Class.forName(string).newInstance();
                project.addBuildListener(buildListener);
            }
            catch (Exception exception) {
                throw new BuildException("Unable to instantiate listener " + string, exception);
            }
            ++n;
        }
    }

    private BuildLogger createLogger() {
        BuildLogger buildLogger = null;
        if (this.loggerClassname != null) {
            try {
                buildLogger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException classCastException) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception exception) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + exception.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            buildLogger = new DefaultLogger();
        }
        buildLogger.setMessageOutputLevel(this.msgOutputLevel);
        buildLogger.setOutputPrintStream(this.out);
        buildLogger.setErrorPrintStream(this.err);
        buildLogger.setEmacsMode(this.emacsMode);
        return buildLogger;
    }

    private static void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ant [options] [target [target2 [target3] ...]]" + string);
        stringBuffer.append("Options: " + string);
        stringBuffer.append("  -help                  print this message" + string);
        stringBuffer.append("  -projecthelp           print project help information" + string);
        stringBuffer.append("  -version               print the version information and exit" + string);
        stringBuffer.append("  -quiet                 be extra quiet" + string);
        stringBuffer.append("  -verbose               be extra verbose" + string);
        stringBuffer.append("  -debug                 print debugging information" + string);
        stringBuffer.append("  -emacs                 produce logging information without adornments" + string);
        stringBuffer.append("  -logfile <file>        use given file for log" + string);
        stringBuffer.append("  -logger <classname>    the class which is to perform logging" + string);
        stringBuffer.append("  -listener <classname>  add an instance of class as a project listener" + string);
        stringBuffer.append("  -buildfile <file>      use given buildfile" + string);
        stringBuffer.append("  -D<property>=<value>   use value for given property" + string);
        stringBuffer.append("  -find <file>           search for buildfile towards the root of the" + string);
        stringBuffer.append("                         filesystem and use it" + string);
        System.out.println(stringBuffer.toString());
    }

    private static void printVersion() throws BuildException {
        System.out.println(Main.getAntVersion());
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties properties = new Properties();
                InputStream inputStream = (class$org$apache$tools$ant$Main == null ? (class$org$apache$tools$ant$Main = Main.class$("org.apache.tools.ant.Main")) : class$org$apache$tools$ant$Main).getResourceAsStream("/org/apache/tools/ant/version.txt");
                properties.load(inputStream);
                inputStream.close();
                String string = System.getProperty("line.separator");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Ant version ");
                stringBuffer.append(properties.getProperty("VERSION"));
                stringBuffer.append(" compiled on ");
                stringBuffer.append(properties.getProperty("DATE"));
                antVersion = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not load the version information:" + iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printTargets(Project project) {
        int n = 0;
        Enumeration enumeration = project.getTargets().elements();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            int n2;
            Target target = (Target)enumeration.nextElement();
            String string = target.getName();
            String string2 = target.getDescription();
            if (string2 == null) {
                n2 = Main.findTargetPosition(vector3, string);
                vector3.insertElementAt(string, n2);
                continue;
            }
            n2 = Main.findTargetPosition(vector, string);
            vector.insertElementAt(string, n2);
            vector2.insertElementAt(string2, n2);
            if (string.length() <= n) continue;
            n = string.length();
        }
        String string = project.getDefaultTarget();
        if (string != null && !"".equals(string)) {
            Vector<String> vector4 = new Vector<String>();
            Vector vector5 = null;
            vector4.addElement(string);
            int n3 = vector.indexOf(string);
            if (n3 >= 0) {
                vector5 = new Vector();
                vector5.addElement(vector2.elementAt(n3));
            }
            Main.printTargets(vector4, vector5, "Default target:", n);
        }
        Main.printTargets(vector, vector2, "Main targets:", n);
        Main.printTargets(vector3, null, "Subtargets:", 0);
    }

    private static int findTargetPosition(Vector vector, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < vector.size() && n == vector.size()) {
            if (string.compareTo((String)vector.elementAt(n2)) < 0) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private static void printTargets(Vector vector, Vector vector2, String string, int n) {
        String string2 = System.getProperty("line.separator");
        String string3 = "    ";
        while (string3.length() < n) {
            string3 = string3 + string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + string2 + string2);
        int n2 = 0;
        while (n2 < vector.size()) {
            stringBuffer.append(" ");
            stringBuffer.append(vector.elementAt(n2));
            if (vector2 != null) {
                stringBuffer.append(string3.substring(0, n - ((String)vector.elementAt(n2)).length() + 2));
                stringBuffer.append(vector2.elementAt(n2));
            }
            stringBuffer.append(string2);
            ++n2;
        }
        System.out.println(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

