/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;

public class IntrospectionHelper
implements BuildListener {
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private Method addText = null;
    private Class bean;
    private static Hashtable helpers = new Hashtable();
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$Location;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Path;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;

    private IntrospectionHelper(Class clazz) {
        this.bean = clazz;
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            final Method method = methodArray[n];
            String string = method.getName();
            Class<?> clazz2 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            if (!((class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(clazz) && classArray.length == 1 && ("setLocation".equals(string) && (class$org$apache$tools$ant$Location == null ? IntrospectionHelper.class$("org.apache.tools.ant.Location") : class$org$apache$tools$ant$Location).equals(classArray[0]) || "setTaskType".equals(string) && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(classArray[0])))) {
                Object object;
                Object object2;
                if ("addText".equals(string) && Void.TYPE.equals(clazz2) && classArray.length == 1 && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(classArray[0])) {
                    this.addText = methodArray[n];
                } else if (string.startsWith("set") && Void.TYPE.equals(clazz2) && classArray.length == 1 && !classArray[0].isArray()) {
                    object2 = this.getPropertyName(string, "set");
                    object = this.createAttributeSetter(method, classArray[0]);
                    if (object != null) {
                        this.attributeTypes.put(object2, classArray[0]);
                        this.attributeSetters.put(object2, object);
                    }
                } else if (string.startsWith("create") && !clazz2.isArray() && !clazz2.isPrimitive() && classArray.length == 0) {
                    object2 = this.getPropertyName(string, "create");
                    this.nestedTypes.put(object2, clazz2);
                    this.nestedCreators.put(object2, new NestedCreator(){

                        public Object create(Object object) throws InvocationTargetException, IllegalAccessException {
                            return method.invoke(object, new Object[0]);
                        }
                    });
                } else if (string.startsWith("add") && Void.TYPE.equals(clazz2) && classArray.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(classArray[0]) && !classArray[0].isArray() && !classArray[0].isPrimitive()) {
                    try {
                        object2 = classArray[0].getConstructor(new Class[0]);
                        object = this.getPropertyName(string, "add");
                        this.nestedTypes.put(object, classArray[0]);
                        this.nestedCreators.put(object, new NestedCreator((Constructor)object2, method){
                            private final /* synthetic */ Constructor val$c;
                            private final /* synthetic */ Method val$m;
                            {
                                this.val$c = constructor;
                                this.val$m = method;
                            }

                            public Object create(Object object) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                Object t = this.val$c.newInstance(new Object[0]);
                                this.val$m.invoke(object, t);
                                return t;
                            }
                        });
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
    }

    public static synchronized IntrospectionHelper getHelper(Class clazz) {
        IntrospectionHelper introspectionHelper = (IntrospectionHelper)helpers.get(clazz);
        if (introspectionHelper == null) {
            introspectionHelper = new IntrospectionHelper(clazz);
            helpers.put(clazz, introspectionHelper);
        }
        return introspectionHelper;
    }

    public void setAttribute(Project project, Object object, String string, String string2) throws BuildException {
        AttributeSetter attributeSetter = (AttributeSetter)this.attributeSetters.get(string);
        if (attributeSetter == null) {
            String string3 = this.getElementName(project, object) + " doesn't support the \"" + string + "\" attribute.";
            throw new BuildException(string3);
        }
        try {
            attributeSetter.set(project, object, string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof BuildException) {
                throw (BuildException)throwable;
            }
            throw new BuildException(throwable);
        }
    }

    public void addText(Project project, Object object, String string) {
        if (this.addText == null) {
            String string2 = this.getElementName(project, object) + " doesn't support nested text data.";
            throw new BuildException(string2);
        }
        try {
            this.addText.invoke(object, (Object[])new String[]{string});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof BuildException) {
                throw (BuildException)throwable;
            }
            throw new BuildException(throwable);
        }
    }

    public Object createElement(Project project, Object object, String string) throws BuildException {
        NestedCreator nestedCreator = (NestedCreator)this.nestedCreators.get(string);
        if (nestedCreator == null) {
            String string2 = this.getElementName(project, object) + " doesn't support the nested \"" + string + "\" element.";
            throw new BuildException(string2);
        }
        try {
            return nestedCreator.create(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof BuildException) {
                throw (BuildException)throwable;
            }
            throw new BuildException(throwable);
        }
    }

    public Class getElementType(String string) throws BuildException {
        Class clazz = (Class)this.nestedTypes.get(string);
        if (clazz == null) {
            String string2 = "Class " + this.bean.getName() + " doesn't support the nested \"" + string + "\" element.";
            throw new BuildException(string2);
        }
        return clazz;
    }

    public Class getAttributeType(String string) throws BuildException {
        Class clazz = (Class)this.attributeTypes.get(string);
        if (clazz == null) {
            String string2 = "Class " + this.bean.getName() + " doesn't support the \"" + string + "\" attribute.";
            throw new BuildException(string2);
        }
        return clazz;
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    private AttributeSetter createAttributeSetter(final Method method, final Class clazz) {
        if ((class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new String[]{string});
                }
            };
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character")) : class$java$lang$Character).equals(clazz) || Character.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Character[]{new Character(string.charAt(0))});
                }
            };
        }
        if (Byte.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Byte[]{new Byte(string)});
                }
            };
        }
        if (Short.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Short[]{new Short(string)});
                }
            };
        }
        if (Integer.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Integer[]{new Integer(string)});
                }
            };
        }
        if (Long.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Long[]{new Long(string)});
                }
            };
        }
        if (Float.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Float[]{new Float(string)});
                }
            };
        }
        if (Double.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Double[]{new Double(string)});
                }
            };
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Boolean[]{new Boolean(Project.toBoolean(string))});
                }
            };
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = IntrospectionHelper.class$("java.lang.Class")) : class$java$lang$Class).equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        method.invoke(object, (Object[])new Class[]{Class.forName(string)});
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new BuildException(classNotFoundException);
                    }
                }
            };
        }
        if ((class$java$io$File == null ? (class$java$io$File = IntrospectionHelper.class$("java.io.File")) : class$java$io$File).equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new File[]{project.resolveFile(string)});
                }
            };
        }
        if ((class$org$apache$tools$ant$types$Path == null ? (class$org$apache$tools$ant$types$Path = IntrospectionHelper.class$("org.apache.tools.ant.types.Path")) : class$org$apache$tools$ant$types$Path).equals(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Path[]{new Path(project, string)});
                }
            };
        }
        if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? (class$org$apache$tools$ant$types$EnumeratedAttribute = IntrospectionHelper.class$("org.apache.tools.ant.types.EnumeratedAttribute")) : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(clazz)) {
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute enumeratedAttribute = (EnumeratedAttribute)clazz.newInstance();
                        enumeratedAttribute.setValue(string);
                        method.invoke(object, (Object[])new EnumeratedAttribute[]{enumeratedAttribute});
                    }
                    catch (InstantiationException instantiationException) {
                        throw new BuildException(instantiationException);
                    }
                }
            };
        }
        try {
            final Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String);
            return new AttributeSetter(){

                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        method.invoke(object, constructor.newInstance(string));
                    }
                    catch (InstantiationException instantiationException) {
                        throw new BuildException(instantiationException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected String getElementName(Project project, Object object) {
        Hashtable hashtable = project.getTaskDefinitions();
        String string = "task";
        if (!hashtable.contains(object.getClass())) {
            hashtable = project.getDataTypeDefinitions();
            string = "data type";
            if (!hashtable.contains(object.getClass())) {
                hashtable = null;
            }
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Class clazz = (Class)hashtable.get(string2);
                if (!object.getClass().equals(clazz)) continue;
                return "The <" + string2 + "> " + string;
            }
        }
        return "Class " + object.getClass().getName();
    }

    private String getPropertyName(String string, String string2) {
        int n = string2.length();
        return string.substring(n).toLowerCase();
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.attributeTypes.clear();
        this.attributeSetters.clear();
        this.nestedTypes.clear();
        this.nestedCreators.clear();
        this.addText = null;
        helpers.clear();
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static interface AttributeSetter {
        public void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }

    private static interface NestedCreator {
        public Object create(Object var1) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }
}

