/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class DomHash {
    public static CRC32 crc = new CRC32();

    private static void fall(String[] stringArray, int n, int n2) {
        int n3 = 2 * n2 + 1;
        if (n3 < n) {
            if (n3 + 1 < n && stringArray[n3].compareTo(stringArray[n3 + 1]) < 0) {
                n3 = 2 * n2 + 2;
            }
            if (stringArray[n2].compareTo(stringArray[n3]) < 0) {
                String string = stringArray[n2];
                stringArray[n2] = stringArray[n3];
                stringArray[n3] = string;
                DomHash.fall(stringArray, n, n3);
            }
        }
    }

    public static long getElementHash(Element element) {
        Attr[] attrArray = null;
        long l = 0L;
        try {
            Attr attr;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(1);
            dataOutputStream.write(element.getTagName().getBytes());
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            int n = 0;
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap != null && (n = namedNodeMap.getLength()) != 0) {
                attrArray = new Attr[n];
                Vector<String> vector = new Vector<String>();
                int n2 = 0;
                while (n2 < n) {
                    vector.addElement(namedNodeMap.item(n2).getNodeName());
                    ++n2;
                }
                DomHash.sortStringVector(vector);
                int n3 = 0;
                while (n3 < n) {
                    attrArray[n3] = attr = element.getAttributeNode((String)vector.elementAt(n3));
                    ++n3;
                }
            }
            if (attrArray == null || (n = attrArray.length) == 0) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(n);
                int n4 = 0;
                while (n4 < n) {
                    attr = attrArray[n4];
                    dataOutputStream.writeInt(2);
                    dataOutputStream.writeBytes(attr.getName());
                    dataOutputStream.writeBytes(attr.getValue());
                    ++n4;
                }
            }
            dataOutputStream.close();
            crc.reset();
            crc.update(byteArrayOutputStream.toByteArray());
            l = crc.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return l;
    }

    public static String getXMLDisplayString(String string) {
        char[] cArray = new char[string.length() * 2];
        String string2 = "&lt;";
        String string3 = "&gt;";
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (!bl) {
            n = string.indexOf(60, n3);
            n2 = string.indexOf(62, n);
            if (n < n3) break;
            string.getChars(n3, n, cArray, n4);
            string2.getChars(0, string2.length(), cArray, n4 += n - n3);
            n4 += string2.length();
            if (n2 <= n) break;
            string.getChars(n + 1, n2, cArray, n4);
            string3.getChars(0, string3.length(), cArray, n4 += n2 - n - 1);
            n4 += string3.length();
            n3 = n2 + 1;
            if (n <= string.length() && n2 <= string.length()) continue;
            bl = true;
        }
        return new String(cArray);
    }

    private static void heapSort(String[] stringArray) {
        int n = stringArray.length / 2;
        while (n >= 0) {
            DomHash.fall(stringArray, stringArray.length, n);
            --n;
        }
        n = stringArray.length - 1;
        while (n > 0) {
            String string = stringArray[0];
            stringArray[0] = stringArray[n];
            stringArray[n] = string;
            DomHash.fall(stringArray, n, 0);
            --n;
        }
    }

    private static Vector sortStringVector(Vector vector) {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        DomHash.heapSort((String[])objectArray);
        vector.removeAllElements();
        vector.ensureCapacity(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    public static void updateLong(Checksum checksum, long l) {
        checksum.update((byte)(l >> 56 & 0xFFL));
        checksum.update((byte)(l >> 48 & 0xFFL));
        checksum.update((byte)(l >> 40 & 0xFFL));
        checksum.update((byte)(l >> 32 & 0xFFL));
        checksum.update((byte)(l >> 24 & 0xFFL));
        checksum.update((byte)(l >> 16 & 0xFFL));
        checksum.update((byte)(l >> 8 & 0xFFL));
        checksum.update((byte)(l & 0xFFL));
    }
}

