/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.smtp;

import com.ibm.network.mail.base.InternetAddress;
import com.ibm.network.mail.base.MimeBodyPart;
import com.ibm.network.mail.base.MimeMessage;
import com.ibm.network.mail.pop3.event.MessageEvent;
import com.ibm.network.mail.pop3.event.MessageListener;
import com.ibm.network.mail.pop3.event.StatusListener;
import com.ibm.network.mail.smtp.event.StatusEvent;
import com.ibm.network.mail.smtp.protocol.CoreProtocolBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.smtp.POP3StatusListener;
import org.apache.soap.transport.smtp.SMTPConstants;

public class SOAPSMTPConnection
implements SOAPTransport {
    private String fromAddr;
    private String subject;
    private Object waitObject = new Object();
    private long popPollDelay;
    private boolean responseReceived = false;
    private Hashtable responseHeaders = new Hashtable();
    private BufferedReader responseReader = null;
    CoreProtocolBean smtpBean = new CoreProtocolBean();
    com.ibm.network.mail.pop3.protocol.CoreProtocolBean pop3Bean = new com.ibm.network.mail.pop3.protocol.CoreProtocolBean();

    public SOAPSMTPConnection(String string, String string2, String string3, long l, String string4, String string5, String string6) {
        this.fromAddr = string;
        this.subject = string2;
        this.smtpBean.setSmtpServerHost(string3);
        this.smtpBean.addStatusListener(new com.ibm.network.mail.smtp.event.StatusListener(){

            public void operationComplete(StatusEvent statusEvent) {
                System.err.println("DONE: " + statusEvent.getStatusString());
                Object object = SOAPSMTPConnection.this.waitObject;
                synchronized (object) {
                    SOAPSMTPConnection.this.waitObject.notify();
                }
            }

            public void processStatus(StatusEvent statusEvent) {
                System.err.println("Status update: " + statusEvent.getStatusString());
            }
        });
        this.pop3Bean.setPOP3ServerHost(string4);
        this.pop3Bean.setUserOptions(string5, string6, false, false);
        this.pop3Bean.addMessageListener(new MessageListener(){

            public void messageReceived(MessageEvent messageEvent) {
                String string;
                String string2;
                String string3;
                MimeMessage mimeMessage = messageEvent.getMessage();
                String string4 = mimeMessage.getHeader(SMTPConstants.SMTP_HEADER_SUBJECT);
                if (string4 != null) {
                    SOAPSMTPConnection.this.responseHeaders.put(SMTPConstants.SMTP_HEADER_SUBJECT, string4);
                }
                if ((string3 = mimeMessage.getHeader(Constants.HEADER_SOAP_ACTION)) != null) {
                    SOAPSMTPConnection.this.responseHeaders.put(Constants.HEADER_SOAP_ACTION, string3);
                }
                if ((string2 = mimeMessage.getHeader(SMTPConstants.SMTP_HEADER_TO)) != null) {
                    SOAPSMTPConnection.this.responseHeaders.put(SMTPConstants.SMTP_HEADER_TO, string2);
                }
                if ((string = mimeMessage.getHeader(SMTPConstants.SMTP_HEADER_FROM)) != null) {
                    SOAPSMTPConnection.this.responseHeaders.put(SMTPConstants.SMTP_HEADER_FROM, string);
                }
                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMessage.getContent();
                byte[] byArray = (byte[])mimeBodyPart.getContent();
                String string5 = new String(byArray);
                SOAPSMTPConnection.this.responseReader = new BufferedReader(new StringReader(string5));
                SOAPSMTPConnection.this.responseReceived = true;
            }
        });
        this.pop3Bean.addStatusListener((StatusListener)new POP3StatusListener());
    }

    static /* synthetic */ BufferedReader access$2(SOAPSMTPConnection sOAPSMTPConnection) {
        return sOAPSMTPConnection.responseReader;
    }

    static /* synthetic */ boolean access$4(SOAPSMTPConnection sOAPSMTPConnection) {
        return sOAPSMTPConnection.responseReceived;
    }

    public Hashtable getHeaders() {
        return this.responseHeaders;
    }

    public BufferedReader receive() {
        this.responseReceived = false;
        while (!this.responseReceived) {
            try {
                if (this.pop3Bean.isReady()) {
                    System.err.println("SOAPSMTPConnection: Polling for response ..");
                    this.pop3Bean.receiveMessage();
                    if (this.responseReceived) break;
                }
                Thread.sleep(this.popPollDelay);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.responseReader;
    }

    public void send(URL uRL, String string, Hashtable hashtable, Envelope envelope, SOAPMappingRegistry sOAPMappingRegistry) throws SOAPException {
        MimeMessage mimeMessage = new MimeMessage();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        StringWriter stringWriter = new StringWriter();
        try {
            envelope.marshall(stringWriter, sOAPMappingRegistry);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        mimeBodyPart.setContent((Object)stringWriter.toString(), "text/xml");
        mimeBodyPart.setEncoding(4);
        mimeBodyPart.setDisposition(2);
        mimeMessage.setContent((Object)mimeBodyPart, "");
        mimeMessage.addHeader("Subject", this.subject);
        mimeMessage.addHeader("SOAPAction", string);
        mimeMessage.addHeader("From", this.fromAddr);
        mimeMessage.addRecipients(0, new InternetAddress[]{new InternetAddress(uRL.getFile())});
        this.smtpBean.sendMessage(mimeMessage);
        try {
            Object object = this.waitObject;
            synchronized (object) {
                this.waitObject.wait();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

