/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.util.net.HTTPUtils;

public class SOAPHTTPConnection
implements SOAPTransport {
    private BufferedReader responseReader;
    private Hashtable responseHeaders;

    public Hashtable getHeaders() {
        return this.responseHeaders;
    }

    public BufferedReader receive() {
        return this.responseReader;
    }

    public void send(URL uRL, String string, Hashtable hashtable, Envelope envelope, SOAPMappingRegistry sOAPMappingRegistry) throws SOAPException {
        try {
            StringWriter stringWriter = new StringWriter();
            envelope.marshall(stringWriter, sOAPMappingRegistry);
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            hashtable.put(Constants.HEADER_SOAP_ACTION, string != null ? String.valueOf('\"') + string + '\"' : "");
            HTTPUtils.Response response = HTTPUtils.post(uRL, hashtable, Constants.HEADERVAL_CONTENT_TYPE, stringWriter.toString());
            this.responseReader = response.content;
            this.responseHeaders = response.headers;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, iOException.getMessage(), iOException);
        }
    }
}

