/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.apache.soap.util.xml.XercesParserLiaison;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RPCRouterServlet
extends HttpServlet {
    private static final String RPC_ROUTER_ID = "rpcRouter";
    private static final String SERVICE_MANAGER_ID = "serviceManager";
    private static final String SCRIPT_CLASS = "com.ibm.bsf.BSFManager";
    private static final String SCRIPT_INVOKER = "org.apache.soap.server.InvokeBSF";
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<body><h1>SOAP RPC Router</h1>");
        printWriter.println("<p>Sorry, I don't speak via HTTP GET- you have to use");
        printWriter.println("HTTP POST to talk to me.</p></body>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        HttpSession httpSession = httpServletRequest.getSession();
        RPCRouter rPCRouter = (RPCRouter)servletContext.getAttribute(RPC_ROUTER_ID);
        ServiceManager serviceManager = (ServiceManager)servletContext.getAttribute(SERVICE_MANAGER_ID);
        Response response = null;
        String string = null;
        String string2 = httpServletRequest.getContentType();
        int n = httpServletRequest.getContentLength();
        httpServletResponse.setContentType(Constants.HEADERVAL_CONTENT_TYPE_UTF8);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"), true);
        Call call = null;
        if (string2 == null || !string2.equals(Constants.HEADERVAL_CONTENT_TYPE)) {
            httpServletResponse.sendError(400, "Content type must be: '" + Constants.HEADERVAL_CONTENT_TYPE + "'.");
            return;
        }
        if (n < 0) {
            httpServletResponse.sendError(400, "Content length must be specified.");
            return;
        }
        try {
            Class[] classArray;
            Object object3;
            Object object4;
            System.err.println(">>(" + new Date() + ") Processing SOAP request...");
            object2 = httpServletRequest.getReader();
            object = new char[n];
            int n2 = 0;
            while (n2 < n) {
                n2 += ((Reader)object2).read((char[])object, n2, n - n2);
            }
            XercesParserLiaison xercesParserLiaison = new XercesParserLiaison();
            Document document = xercesParserLiaison.read("- SOAP HTTP RPC Call Envelope -", new CharArrayReader((char[])object));
            Element element = null;
            if (document == null) {
                throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "DOM parsing error: " + object);
            }
            try {
                element = document.getDocumentElement();
                object4 = Envelope.unmarshall(element);
                call = rPCRouter.extractCallFromEnvelope((Envelope)object4);
                string = call.getTargetObjectURI();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string3 = illegalArgumentException.getMessage();
                String string4 = string3 != null && string3.equals(Constants.ERR_MSG_VERSION_MISMATCH) ? Constants.FAULT_CODE_VERSION_MISMATCH : Constants.FAULT_CODE_CLIENT;
                throw new SOAPException(string4, string3, illegalArgumentException);
            }
            if (!rPCRouter.validCall(call)) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + call.getMethodName() + "' is not supported.");
            }
            object4 = serviceManager.query(string);
            int n3 = ((DeploymentDescriptor)object4).getScope();
            byte by = ((DeploymentDescriptor)object4).getProviderType();
            Object object5 = null;
            String string5 = by == 0 ? ((DeploymentDescriptor)object4).getProviderClass() : SCRIPT_CLASS;
            RPCRouterServlet rPCRouterServlet = null;
            if (n3 == 0) {
                rPCRouterServlet = this;
            } else if (n3 == 1) {
                rPCRouterServlet = httpSession;
            } else if (n3 == 2) {
                rPCRouterServlet = servletContext;
            } else {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Service uses deprecated object scope 'page': inform provider of error");
            }
            boolean bl = false;
            if (string.equals("urn:xml-soap-service-management-service")) {
                object5 = serviceManager;
            } else {
                object3 = rPCRouterServlet;
                synchronized (object3) {
                    object5 = rPCRouterServlet == httpSession ? httpSession.getAttribute(string) : (rPCRouterServlet == servletContext ? servletContext.getAttribute(string) : null);
                    if (object5 == null) {
                        try {
                            classArray = Class.forName(string5);
                            object5 = ((DeploymentDescriptor)object4).getIsStatic() ? classArray : classArray.newInstance();
                            bl = true;
                        }
                        catch (Exception exception) {
                            String string6 = by == 0 ? "Unable to resolve target object: " + exception.getMessage() : "Unable to load BSF: script services not available without BSF: " + exception.getMessage();
                            throw new SOAPException(RPCConstants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, string6, exception);
                        }
                    }
                    if (rPCRouterServlet == httpSession) {
                        httpSession.setAttribute(string, object5);
                    } else if (rPCRouterServlet == servletContext) {
                        servletContext.setAttribute(string, object5);
                    }
                }
            }
            if (by != 0 && bl) {
                object3 = Class.forName(SCRIPT_INVOKER);
                String string7 = ((DeploymentDescriptor)object4).getScriptFilenameOrString();
                if (by == 1) {
                    classArray = servletContext.getRealPath(string7);
                    string7 = IOUtils.getStringFromReader(new FileReader((String)classArray));
                }
                classArray = new Class[]{class$org$apache$soap$server$DeploymentDescriptor != null ? class$org$apache$soap$server$DeploymentDescriptor : (class$org$apache$soap$server$DeploymentDescriptor = RPCRouterServlet.class$("org.apache.soap.server.DeploymentDescriptor")), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = RPCRouterServlet.class$("java.lang.Object")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RPCRouterServlet.class$("java.lang.String"))};
                Method method = MethodUtils.getMethod((Class)object3, "init", classArray, true);
                method.invoke(null, object4, object5, string7);
            }
            response = rPCRouter.invoke(call, object5);
        }
        catch (SOAPException sOAPException) {
            object = new Fault();
            String string8 = sOAPException.getFaultCode();
            String string9 = sOAPException.getMessage();
            if (string8 == null || string8.startsWith(Constants.FAULT_CODE_SERVER)) {
                httpServletResponse.setStatus(500);
            } else if (string8.startsWith(Constants.FAULT_CODE_CLIENT)) {
                httpServletResponse.setStatus(400);
            }
            ((Fault)object).setFaultCode(string8);
            ((Fault)object).setFaultString(string9);
            ((Fault)object).setFaultActorURI(httpServletRequest.getRequestURI());
            response = new Response(null, null, (Fault)object, null, null, null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throwable.printStackTrace(printWriter);
        }
        if (response != null) {
            try {
                object2 = response.buildEnvelope();
                object = call != null ? call.getSOAPMappingRegistry() : new SOAPMappingRegistry();
                ((Envelope)object2).marshall(printWriter, (XMLJavaMappingRegistry)object);
            }
            catch (Exception exception) {
                throw new ServletException("Error building response envelope", (Throwable)exception);
            }
        }
        printWriter.close();
        httpServletResponse.setContentLength(byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo((OutputStream)httpServletResponse.getOutputStream());
    }

    public void init() throws ServletException {
        ServletContext servletContext;
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext2 = servletContext = servletConfig.getServletContext();
        synchronized (servletContext2) {
            Object object = servletContext.getAttribute(RPC_ROUTER_ID);
            if (object == null) {
                RPCRouter rPCRouter = new RPCRouter();
                ServiceManager serviceManager = new ServiceManager();
                rPCRouter.setServiceManager(serviceManager);
                servletContext.setAttribute(RPC_ROUTER_ID, (Object)rPCRouter);
                servletContext.setAttribute(SERVICE_MANAGER_ID, (Object)serviceManager);
            }
        }
    }
}

