/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Vector;
import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.BeanSerializer;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.TypeMappingSerializer;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XercesParserLiaison;
import org.w3c.dom.Document;

public class ServiceManagerClient {
    URL routerURL;
    Vector params = new Vector();
    Call call = new Call();
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$org$apache$soap$server$TypeMapping;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$soap$server$ServiceManagerClient;

    public ServiceManagerClient(URL uRL) {
        Deserializer deserializer = new BeanSerializer();
        this.routerURL = uRL;
        SOAPMappingRegistry sOAPMappingRegistry = this.call.getSOAPMappingRegistry();
        sOAPMappingRegistry.mapTypes(Constants.NS_URI_SOAP_ENC, new QName(Constants.NS_URI_XML_SOAP, "DeploymentDescriptor"), class$org$apache$soap$server$DeploymentDescriptor != null ? class$org$apache$soap$server$DeploymentDescriptor : (class$org$apache$soap$server$DeploymentDescriptor = ServiceManagerClient.class$("org.apache.soap.server.DeploymentDescriptor")), (Serializer)((Object)deserializer), deserializer);
        deserializer = new TypeMappingSerializer();
        sOAPMappingRegistry.mapTypes(Constants.NS_URI_SOAP_ENC, new QName(Constants.NS_URI_XML_SOAP, "TypeMapping"), class$org$apache$soap$server$TypeMapping != null ? class$org$apache$soap$server$TypeMapping : (class$org$apache$soap$server$TypeMapping = ServiceManagerClient.class$("org.apache.soap.server.TypeMapping")), (Serializer)((Object)deserializer), deserializer);
    }

    private static void badUsage() {
        System.err.println("Usage: java " + (class$org$apache$soap$server$ServiceManagerClient != null ? class$org$apache$soap$server$ServiceManagerClient : (class$org$apache$soap$server$ServiceManagerClient = ServiceManagerClient.class$("org.apache.soap.server.ServiceManagerClient"))).getName() + " url operation arguments");
        System.err.println("where");
        System.err.println("\turl is the XML-SOAP router's URL whose services are managed");
        System.err.println("\toperation and arguments are:");
        System.err.println("\t\tdeploy deployment-descriptor-file.xml");
        System.err.println("\t\tlist");
        System.err.println("\t\tquery service-name");
        System.err.println("\t\tundeploy service-name");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void deploy(DeploymentDescriptor deploymentDescriptor) throws SOAPException {
        Parameter parameter = new Parameter("descriptor", class$org$apache$soap$server$DeploymentDescriptor != null ? class$org$apache$soap$server$DeploymentDescriptor : (class$org$apache$soap$server$DeploymentDescriptor = ServiceManagerClient.class$("org.apache.soap.server.DeploymentDescriptor")), deploymentDescriptor, null);
        this.invokeMethod("deploy", parameter);
    }

    private Response invokeMethod(String string, Parameter parameter) throws SOAPException {
        this.call.setTargetObjectURI("urn:xml-soap-service-management-service");
        this.call.setMethodName(string);
        this.call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
        if (parameter != null) {
            this.params.removeAllElements();
            this.params.addElement(parameter);
            this.call.setParams(this.params);
        } else {
            this.call.setParams(null);
        }
        Response response = this.call.invoke(this.routerURL, "");
        if (response.generatedFault()) {
            Fault fault = response.getFault();
            System.out.println("Ouch, the call failed: ");
            System.out.println("  Fault Code   = " + fault.getFaultCode());
            System.out.println("  Fault String = " + fault.getFaultString());
        }
        return response;
    }

    public String[] list() throws SOAPException {
        Response response = this.invokeMethod("list", null);
        if (!response.generatedFault()) {
            Parameter parameter = response.getReturnValue();
            return (String[])parameter.getValue();
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            ServiceManagerClient.badUsage();
        }
        ServiceManagerClient serviceManagerClient = new ServiceManagerClient(new URL(stringArray[0]));
        String string = stringArray[1];
        if (string.equals("deploy")) {
            if (stringArray.length != 3) {
                ServiceManagerClient.badUsage();
            }
            FileReader fileReader = new FileReader(stringArray[2]);
            XercesParserLiaison xercesParserLiaison = new XercesParserLiaison();
            Document document = xercesParserLiaison.read(stringArray[2], fileReader);
            serviceManagerClient.deploy(DeploymentDescriptor.fromXML(document.getDocumentElement()));
        } else if (string.equals("undeploy")) {
            if (stringArray.length != 3) {
                ServiceManagerClient.badUsage();
            }
            serviceManagerClient.undeploy(stringArray[2]);
        } else if (string.equals("list")) {
            String[] stringArray2 = serviceManagerClient.list();
            if (stringArray2 != null) {
                System.out.println("Deployed Services:");
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println("\t" + stringArray2[n]);
                    ++n;
                }
            }
        } else if (string.equals("query")) {
            DeploymentDescriptor deploymentDescriptor;
            if (stringArray.length != 3) {
                ServiceManagerClient.badUsage();
            }
            if ((deploymentDescriptor = serviceManagerClient.query(stringArray[2])) != null) {
                deploymentDescriptor.toXML(new OutputStreamWriter(System.out));
            }
        } else {
            ServiceManagerClient.badUsage();
        }
    }

    public DeploymentDescriptor query(String string) throws SOAPException {
        Parameter parameter = new Parameter("name", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ServiceManagerClient.class$("java.lang.String")), string, null);
        Response response = this.invokeMethod("query", parameter);
        if (!response.generatedFault()) {
            Parameter parameter2 = response.getReturnValue();
            return (DeploymentDescriptor)parameter2.getValue();
        }
        return null;
    }

    public void undeploy(String string) throws SOAPException {
        Parameter parameter = new Parameter("name", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ServiceManagerClient.class$("java.lang.String")), string, null);
        this.invokeMethod("undeploy", parameter);
    }
}

