/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.util.xml.QName;

public class ServiceManager {
    Hashtable dds;
    String filename = "DeployedServices.ds";
    DeploymentDescriptor smsdd = new DeploymentDescriptor();
    String[] serviceNamesCache;

    public ServiceManager() {
        this.smsdd.setID("urn:xml-soap-service-management-service");
        String[] stringArray = new String[]{"deploy", "undeploy", "list", "query"};
        this.smsdd.setMethods(stringArray);
        this.smsdd.setScope(2);
        this.smsdd.setProviderType((byte)0);
        this.smsdd.setProviderClass("org.apache.soap.server.ServiceManager");
        this.smsdd.setIsStatic(false);
        this.smsdd.setMappings(new TypeMapping[]{new TypeMapping(Constants.NS_URI_SOAP_ENC, new QName(Constants.NS_URI_XML_SOAP, "DeploymentDescriptor"), "org.apache.soap.server.DeploymentDescriptor", "org.apache.soap.encoding.soapenc.BeanSerializer", "org.apache.soap.encoding.soapenc.BeanSerializer"), new TypeMapping(Constants.NS_URI_SOAP_ENC, new QName(Constants.NS_URI_XML_SOAP, "TypeMapping"), "org.apache.soap.server.TypeMapping", "org.apache.soap.server.TypeMappingSerializer", "org.apache.soap.server.TypeMappingSerializer")});
        try {
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.dds = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            this.dds = new Hashtable();
            System.err.println("SOAP Service Manager: Unable to read '" + this.filename + "': assuming fresh start");
        }
    }

    public void deploy(DeploymentDescriptor deploymentDescriptor) throws SOAPException {
        String string = deploymentDescriptor.getID();
        if (string.equals("urn:xml-soap-service-management-service")) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "service management service 'urn:xml-soap-service-management-service' cannot be user deployed");
        }
        this.dds.put(string, deploymentDescriptor);
        this.saveRegistry();
    }

    public String[] list() {
        if (this.serviceNamesCache != null) {
            return this.serviceNamesCache;
        }
        Enumeration enumeration = this.dds.keys();
        int n = this.dds.size();
        this.serviceNamesCache = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.serviceNamesCache[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        return this.serviceNamesCache;
    }

    public DeploymentDescriptor query(String string) throws SOAPException {
        if (string == null) {
            return null;
        }
        if (string.equals("urn:xml-soap-service-management-service")) {
            return this.smsdd;
        }
        DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)this.dds.get(string);
        if (deploymentDescriptor != null) {
            return deploymentDescriptor;
        }
        throw new SOAPException(Constants.FAULT_CODE_SERVER, "service '" + string + "' unknown");
    }

    private void saveRegistry() throws SOAPException {
        this.serviceNamesCache = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.dds);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error saving services registry: " + exception.getMessage());
        }
    }

    public DeploymentDescriptor undeploy(String string) throws SOAPException {
        DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)this.dds.remove(string);
        if (deploymentDescriptor == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "service '" + string + "' unknown");
        }
        this.saveRegistry();
        return deploymentDescriptor;
    }
}

