/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.soap.Constants;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeploymentDescriptor
implements Serializable {
    public static final int SCOPE_REQUEST = 0;
    public static final int SCOPE_SESSION = 1;
    public static final int SCOPE_APPLICATION = 2;
    public static final byte PROVIDER_JAVA = 0;
    public static final byte PROVIDER_SCRIPT_FILE = 1;
    public static final byte PROVIDER_SCRIPT_STRING = 2;
    String id;
    int scope;
    byte providerType = (byte)-1;
    String providerClass;
    boolean isStatic;
    String scriptFilenameOrString;
    String scriptLanguage;
    String[] methods;
    TypeMapping[] mappings;
    transient SOAPMappingRegistry cachedSMR;

    public static SOAPMappingRegistry buildSOAPMappingRegistry(DeploymentDescriptor deploymentDescriptor) {
        TypeMapping[] typeMappingArray = deploymentDescriptor.getMappings();
        SOAPMappingRegistry sOAPMappingRegistry = deploymentDescriptor.getCachedSMR();
        if (sOAPMappingRegistry != null) {
            return sOAPMappingRegistry;
        }
        sOAPMappingRegistry = new SOAPMappingRegistry();
        if (typeMappingArray != null) {
            int n = 0;
            while (n < typeMappingArray.length) {
                Object object;
                TypeMapping typeMapping = typeMappingArray[n];
                int n2 = 0;
                try {
                    Object object2;
                    n2 = 0;
                    Class<?> clazz = null;
                    if (typeMapping.javaType != null) {
                        clazz = Class.forName(typeMapping.javaType);
                    }
                    n2 = 1;
                    object = null;
                    if (typeMapping.java2XMLClassName != null) {
                        object2 = Class.forName(typeMapping.java2XMLClassName);
                        object = (Serializer)((Class)object2).newInstance();
                    }
                    n2 = 2;
                    object2 = null;
                    if (typeMapping.xml2JavaClassName != null) {
                        Class<?> clazz2 = Class.forName(typeMapping.xml2JavaClassName);
                        object2 = (Deserializer)clazz2.newInstance();
                    }
                    sOAPMappingRegistry.mapTypes(typeMapping.encodingStyle, typeMapping.elementType, clazz, (Serializer)object, (Deserializer)object2);
                }
                catch (Exception exception) {
                    object = "deployment error in SOAP service '" + deploymentDescriptor.getID() + "': ";
                    object = n2 == 0 ? String.valueOf(object) + "class name '" + typeMapping.javaType + "' could not be resolved: " : (n2 == 1 ? String.valueOf(object) + "class name '" + typeMapping.java2XMLClassName + "' could not be " + "resolved as a serializer: " : String.valueOf(object) + "class name '" + typeMapping.xml2JavaClassName + "' could not be " + "resolved as a deserializer: ");
                    throw new IllegalArgumentException(String.valueOf(object) + exception.getMessage());
                }
                ++n;
            }
        }
        deploymentDescriptor.setCachedSMR(sOAPMappingRegistry);
        return sOAPMappingRegistry;
    }

    public static DeploymentDescriptor fromXML(Element element) {
        int n;
        int n2;
        Object object;
        if (element == null || !element.getNamespaceURI().equals(Constants.NS_URI_XML_SOAP_DEPLOYMENT) || !element.getLocalName().equals("service")) {
            throw new IllegalArgumentException("root is null or document element is not {" + Constants.NS_URI_XML_SOAP_DEPLOYMENT + "}service");
        }
        DeploymentDescriptor deploymentDescriptor = new DeploymentDescriptor();
        String string = DOMUtils.getAttribute(element, "id");
        if (string == null) {
            throw new IllegalArgumentException("required 'id' attribute missing in deployment descriptor");
        }
        deploymentDescriptor.setID(string);
        NodeList nodeList = element.getElementsByTagNameNS(Constants.NS_URI_XML_SOAP_DEPLOYMENT, "provider");
        if (nodeList == null || nodeList.getLength() != 1) {
            throw new IllegalArgumentException("exactly one 'provider' element missing in deployment descriptor");
        }
        Element element2 = (Element)nodeList.item(0);
        String string2 = DOMUtils.getAttribute(element2, "type");
        String string3 = DOMUtils.getAttribute(element2, "scope");
        String string4 = DOMUtils.getAttribute(element2, "methods");
        if (string2 == null || !string2.equals("java") && !string2.equals("script") || string3 == null || !string3.equals("Request") && !string3.equals("Session") && !string3.equals("Application") || string4 == null || string4.equals("")) {
            throw new IllegalArgumentException("invalid value for type or scope or methods attribute in provider element of deployment descriptor");
        }
        int n3 = -1;
        if (string2.equals("java")) {
            deploymentDescriptor.setProviderType((byte)0);
            nodeList = element2.getElementsByTagNameNS(Constants.NS_URI_XML_SOAP_DEPLOYMENT, "java");
            if (nodeList == null || nodeList.getLength() != 1) {
                throw new IllegalArgumentException("exactly one 'java' element missing in deployment descriptor");
            }
            element2 = (Element)nodeList.item(0);
            object = DOMUtils.getAttribute(element2, "class");
            if (object == null) {
                throw new IllegalArgumentException("<java> element requires 'class' attribute");
            }
            deploymentDescriptor.setProviderClass((String)object);
            String string5 = DOMUtils.getAttribute(element2, "static");
            n2 = 0;
            if (string5 != null) {
                if (string5.equals("false")) {
                    n2 = 0;
                } else if (string5.equals("true")) {
                    n2 = 1;
                } else {
                    throw new IllegalArgumentException("'static' attribute of <java> element must be true or false");
                }
            }
            deploymentDescriptor.setIsStatic(n2 != 0);
        } else {
            nodeList = element2.getElementsByTagNameNS(Constants.NS_URI_XML_SOAP_DEPLOYMENT, "script");
            if (nodeList == null || nodeList.getLength() != 1) {
                throw new IllegalArgumentException("exactly one 'script' element missing in deployment descriptor");
            }
            element2 = (Element)nodeList.item(0);
            deploymentDescriptor.setScriptLanguage(DOMUtils.getAttribute(element2, "language"));
            object = DOMUtils.getAttribute(element2, "source");
            if (object != null) {
                deploymentDescriptor.setProviderType((byte)1);
                deploymentDescriptor.setScriptFilenameOrString((String)object);
            } else {
                deploymentDescriptor.setProviderType((byte)2);
                deploymentDescriptor.setScriptFilenameOrString(DOMUtils.getChildCharacterData(element2));
            }
        }
        n3 = string3.equals("Request") ? 0 : (string3.equals("Session") ? 1 : 2);
        deploymentDescriptor.setScope(n3);
        object = new StringTokenizer(string4);
        int n4 = ((StringTokenizer)object).countTokens();
        String[] stringArray = new String[n4];
        n2 = 0;
        while (n2 < n4) {
            stringArray[n2] = ((StringTokenizer)object).nextToken();
            ++n2;
        }
        deploymentDescriptor.setMethods(stringArray);
        nodeList = element.getElementsByTagNameNS(Constants.NS_URI_XML_SOAP_DEPLOYMENT, "mappings");
        if (nodeList == null || nodeList.getLength() > 1) {
            throw new IllegalArgumentException("at most one 'mappings' element allowed in deployment descriptor");
        }
        if (nodeList.getLength() == 1 && (n = (nodeList = (element2 = (Element)nodeList.item(0)).getElementsByTagNameNS(Constants.NS_URI_XML_SOAP_DEPLOYMENT, "map")).getLength()) > 0) {
            TypeMapping[] typeMappingArray = new TypeMapping[n];
            deploymentDescriptor.setMappings(typeMappingArray);
            int n5 = 0;
            while (n5 < n) {
                element2 = (Element)nodeList.item(n5);
                String string6 = DOMUtils.getAttribute(element2, "qname");
                int n6 = string6.indexOf(58);
                String string7 = string6.substring(0, n6);
                String string8 = string6.substring(n6 + 1);
                String string9 = DOMUtils.getNamespaceURIFromPrefix(element2, string7);
                typeMappingArray[n5] = new TypeMapping(DOMUtils.getAttribute(element2, "encodingStyle"), new QName(string9, string8), DOMUtils.getAttribute(element2, "javaType"), DOMUtils.getAttribute(element2, "java2XMLClassName"), DOMUtils.getAttribute(element2, "java2XMLClassName"));
                ++n5;
            }
        }
        return deploymentDescriptor;
    }

    private SOAPMappingRegistry getCachedSMR() {
        return this.cachedSMR;
    }

    public String getID() {
        return this.id;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public TypeMapping[] getMappings() {
        return this.mappings;
    }

    public String[] getMethods() {
        return this.methods;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public byte getProviderType() {
        return this.providerType;
    }

    public int getScope() {
        return this.scope;
    }

    public String getScriptFilenameOrString() {
        return this.scriptFilenameOrString;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    private void setCachedSMR(SOAPMappingRegistry sOAPMappingRegistry) {
        this.cachedSMR = sOAPMappingRegistry;
    }

    public void setID(String string) {
        this.id = string;
    }

    public void setIsStatic(boolean bl) {
        this.isStatic = bl;
    }

    public void setMappings(TypeMapping[] typeMappingArray) {
        this.mappings = typeMappingArray;
    }

    public void setMethods(String[] stringArray) {
        this.methods = stringArray;
    }

    public void setProviderClass(String string) {
        this.providerClass = string;
    }

    public void setProviderType(byte by) {
        this.providerType = by;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public void setScriptFilenameOrString(String string) {
        this.scriptFilenameOrString = string;
    }

    public void setScriptLanguage(String string) {
        this.scriptLanguage = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.methods.length) {
            stringBuffer.append(this.methods[n]);
            if (n < this.methods.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("]");
        String string = "[DeploymentDescriptor id='" + this.id + "', " + "scope='" + this.scope + "', ";
        String string2 = null;
        if (this.providerType == 0) {
            string2 = "class='" + this.providerClass + "', static='" + this.isStatic + "', ";
        } else if (this.providerType == 1) {
            string2 = "source='" + this.scriptFilenameOrString + "', ";
            string2 = String.valueOf(string2) + "language='" + this.scriptLanguage + "', ";
        } else {
            string2 = "script='" + this.scriptFilenameOrString + "', ";
            string2 = String.valueOf(string2) + "language='" + this.scriptLanguage + "', ";
        }
        return String.valueOf(string) + string2 + "methods='" + stringBuffer + "', " + "mappings='" + this.mappings + "]";
    }

    public void toXML(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("<isd:service xmlns:isd=\"" + Constants.NS_URI_XML_SOAP_DEPLOYMENT + "\" id=\"" + this.id + "\">");
        byte by = this.providerType;
        String[] stringArray = new String[]{"Request", "Session", "Application"};
        printWriter.print("  <isd:provider type=\"" + (by == 0 ? "java" : "script") + "\" scope=\"" + stringArray[this.scope] + "\" methods=\"");
        int n = 0;
        while (n < this.methods.length) {
            printWriter.print(this.methods[n]);
            if (n < this.methods.length - 1) {
                printWriter.print(" ");
            }
            ++n;
        }
        printWriter.println("\">");
        if (by == 0) {
            printWriter.println("    <isd:java class=\"" + this.providerClass + "\" static=\"" + (this.isStatic ? "true" : "false") + "\"/>");
        } else {
            printWriter.print("    <isd:script language=\"" + this.scriptLanguage);
            if (by == 1) {
                printWriter.println(" source=\"" + this.scriptFilenameOrString + "\"/>");
            } else {
                printWriter.println("\">");
                printWriter.println("      <![CDATA[");
                printWriter.println(this.scriptFilenameOrString);
                printWriter.println("      ]]>");
                printWriter.println("    </isd:script>");
            }
        }
        printWriter.println("  </isd:provider>");
        if (this.mappings != null) {
            printWriter.println("  <isd:mappings>");
            int n2 = 0;
            while (n2 < this.mappings.length) {
                TypeMapping typeMapping = this.mappings[n2];
                printWriter.print("    <isd:map encodingStyle=\"" + typeMapping.encodingStyle + "\" xmlns:x=\"" + typeMapping.elementType.getNamespaceURI() + "\" qname=\"x:" + typeMapping.elementType.getLocalPart() + "\" javaType=\"" + typeMapping.javaType + "\"");
                if (typeMapping.xml2JavaClassName != null) {
                    printWriter.print(" xml2JavaClassName=\"" + typeMapping.xml2JavaClassName + "\"");
                }
                if (typeMapping.java2XMLClassName != null) {
                    printWriter.print(" java2XMLClassName=\"" + typeMapping.java2XMLClassName + "\"");
                }
                printWriter.println("/>");
                ++n2;
            }
            printWriter.println("  </isd:mappings>");
        }
        printWriter.println("</isd:service>");
        printWriter.flush();
    }
}

