/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.xml.XMLParserLiaison;
import org.apache.soap.util.xml.XercesParserLiaison;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Call
extends RPCMessage {
    private XMLParserLiaison xpl = new XercesParserLiaison();
    private SOAPMappingRegistry smr = new SOAPMappingRegistry();
    private SOAPTransport st = new SOAPHTTPConnection();

    public Call() {
        this(null, null, null, null, null);
    }

    public Call(String string, String string2, Vector vector, Header header, String string3) {
        super(string, string2, vector, header, string3);
    }

    public Envelope buildEnvelope() {
        return super.buildEnvelope(false);
    }

    public static Call extractFromEnvelope(Envelope envelope, ServiceManager serviceManager) throws IllegalArgumentException {
        return (Call)RPCMessage.extractFromEnvelope(envelope, serviceManager, false, null);
    }

    public SOAPMappingRegistry getSOAPMappingRegistry() {
        return this.smr;
    }

    public SOAPTransport getSOAPTransport() {
        return this.st;
    }

    public Response invoke(URL uRL, String string) throws SOAPException {
        if (string == null) {
            string = "";
        }
        try {
            Envelope envelope = this.buildEnvelope();
            this.st.send(uRL, string, null, envelope, this.smr);
            BufferedReader bufferedReader = this.st.receive();
            String string2 = IOUtils.getStringFromReader(bufferedReader);
            Document document = this.xpl.read("- SOAP HTTP RPC Response Envelope -", new StringReader(string2));
            Element element = null;
            if (document == null) {
                throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, string2);
            }
            element = document.getDocumentElement();
            Envelope envelope2 = Envelope.unmarshall(element);
            Response response = Response.extractFromEnvelope(envelope2, this.smr);
            return response;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, iOException.getMessage(), iOException);
        }
    }

    public void setSOAPMappingRegistry(SOAPMappingRegistry sOAPMappingRegistry) {
        this.smr = sOAPMappingRegistry;
    }

    public void setSOAPTransport(SOAPTransport sOAPTransport) {
        this.st = sOAPTransport;
    }
}

