/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;

public class SoapEncUtils {
    public static void generateArrayHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, false);
    }

    public static void generateNullArray(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, true);
    }

    public static void generateNullStructure(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, true);
    }

    public static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, false);
    }

    private static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2, boolean bl) throws IllegalArgumentException, IOException {
        String string3;
        QName qName2 = xMLJavaMappingRegistry.queryElementType(clazz, Constants.NS_URI_SOAP_ENC);
        writer.write(String.valueOf('<') + object.toString());
        String string4 = nSStack.getPrefixFromURI(Constants.NS_URI_SCHEMA_XSI, writer);
        String string5 = nSStack.getPrefixFromURI(qName2.getNamespaceURI(), writer);
        writer.write(String.valueOf(' ') + string4 + ':' + Constants.ATTR_TYPE + "=\"" + string5 + ':' + qName2.getLocalPart() + '\"');
        if (string == null || !string.equals(Constants.NS_URI_SOAP_ENC)) {
            string3 = nSStack.getPrefixFromURI(Constants.NS_URI_SOAP_ENV, writer);
            writer.write(String.valueOf(' ') + string3 + ':' + Constants.ATTR_ENCODING_STYLE + "=\"" + Constants.NS_URI_SOAP_ENC + '\"');
        }
        if (qName != null) {
            string3 = nSStack.getPrefixFromURI(qName.getNamespaceURI(), writer);
            String string6 = String.valueOf(string3) + ':' + qName.getLocalPart() + '[' + string2 + ']';
            String string7 = nSStack.getPrefixFromURI(Constants.NS_URI_SOAP_ENC, writer);
            writer.write(String.valueOf(' ') + string7 + ':' + Constants.ATTR_ARRAY_TYPE + "=\"" + string6 + '\"');
        }
        if (bl) {
            writer.write(String.valueOf(' ') + string4 + ':' + Constants.ATTR_NULL + "=\"" + Constants.ATTRVAL_TRUE + "\"/");
        }
        writer.write(62);
    }

    public static QName getAttributeValue(Element element, String string, String string2, String string3, boolean bl) throws IllegalArgumentException {
        String string4 = DOMUtils.getAttributeNS(element, string, string2);
        if (string4 != null) {
            int n = string4.indexOf(58);
            if (n != -1) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                String string7 = DOMUtils.getNamespaceURIFromPrefix(element, string5);
                if (string7 != null) {
                    return new QName(string7, string6);
                }
                throw new IllegalArgumentException("Unable to resolve namespace URI for '" + string5 + "'.");
            }
            throw new IllegalArgumentException("The value of the '" + string + ':' + string2 + "' attribute must be " + "namespace-qualified.");
        }
        if (bl) {
            throw new IllegalArgumentException("The '" + string + ':' + string2 + "' attribute must be " + "specified for every " + string3 + '.');
        }
        return null;
    }

    public static boolean isNull(Element element) {
        String string = DOMUtils.getAttributeNS(element, Constants.NS_URI_SCHEMA_XSI, Constants.ATTR_NULL);
        return string != null && string.equals(Constants.ATTRVAL_TRUE);
    }
}

