/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeanSerializer
implements Serializer,
Deserializer {
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$apache$soap$rpc$Parameter;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws IllegalArgumentException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {}
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray != null) {
                return propertyDescriptorArray;
            }
            throw new IllegalArgumentException("Unable to retrieve property descriptors for '" + StringUtils.getClassName(clazz) + "'.");
        }
        throw new IllegalArgumentException("Unable to retrieve BeanInfo for '" + StringUtils.getClassName(clazz) + "'.");
    }

    private static Method getWriteMethod(String string, PropertyDescriptor[] propertyDescriptorArray, Class clazz) {
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            if (string.equals(propertyDescriptorArray[n].getName())) {
                return propertyDescriptorArray[n].getWriteMethod();
            }
            ++n;
        }
        throw new IllegalArgumentException("Unable to retrieve PropertyDescriptor for property '" + string + "' of class '" + clazz + "'.");
    }

    private static Object instantiateBean(Class clazz) throws IllegalArgumentException {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Unable to instantiate '" + StringUtils.getClassName(clazz) + "': " + throwable.getMessage());
        }
    }

    public void marshall(String string, Class clazz, Object object, Object object2, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        nSStack.pushScope();
        SoapEncUtils.generateStructureHeader(string, clazz, object2, writer, nSStack, xMLJavaMappingRegistry);
        writer.write(StringUtils.lineSeparator);
        PropertyDescriptor[] propertyDescriptorArray = BeanSerializer.getPropertyDescriptors(clazz);
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            Method method;
            String string2 = propertyDescriptorArray[n].getName();
            Class<?> clazz2 = propertyDescriptorArray[n].getPropertyType();
            if (!clazz2.equals(class$java$lang$Class != null ? class$java$lang$Class : BeanSerializer.class$("java.lang.Class")) && (method = propertyDescriptorArray[n].getReadMethod()) != null) {
                Object object3 = null;
                try {
                    if (object != null) {
                        object3 = method.invoke(object, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Unable to retrieve '" + string2 + "' property " + "value: " + exception.getMessage() + '.');
                }
                Parameter parameter = new Parameter(string2, clazz2, object3, null);
                xMLJavaMappingRegistry.marshall(string, class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : BeanSerializer.class$("org.apache.soap.rpc.Parameter"), parameter, null, writer, nSStack);
                writer.write(StringUtils.lineSeparator);
            }
            ++n;
        }
        writer.write("</" + object2 + '>');
        nSStack.popScope();
    }

    public Bean unmarshall(String string, QName qName, Node node, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException {
        Element element = (Element)node;
        Element element2 = DOMUtils.getFirstChildElement(element);
        Class clazz = xMLJavaMappingRegistry.queryJavaType(qName, string);
        Object object = BeanSerializer.instantiateBean(clazz);
        PropertyDescriptor[] propertyDescriptorArray = BeanSerializer.getPropertyDescriptors(clazz);
        while (element2 != null) {
            Bean bean = xMLJavaMappingRegistry.unmarshall(string, RPCConstants.Q_ELEM_PARAMETER, element2);
            Parameter parameter = (Parameter)bean.value;
            Method method = BeanSerializer.getWriteMethod(parameter.getName(), propertyDescriptorArray, clazz);
            if (method != null) {
                try {
                    method.invoke(object, parameter.getValue());
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Unable to set '" + parameter.getName() + "' property: " + exception.getMessage() + '.');
                }
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return new Bean(clazz, object);
    }
}

