/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import org.apache.soap.Constants;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArraySerializer
implements Serializer,
Deserializer {
    public static Object getNewArray(String string, Element element, QName qName, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException {
        QName qName2 = SoapEncUtils.getAttributeValue(element, Constants.NS_URI_SOAP_ENC, Constants.ATTR_ARRAY_TYPE, "array", true);
        String string2 = qName2.getNamespaceURI();
        String string3 = qName2.getLocalPart();
        int n = string3.lastIndexOf(91);
        int n2 = string3.lastIndexOf(93);
        if (n == -1 || n2 == -1 || n2 < n) {
            throw new IllegalArgumentException("Malformed arrayTypeValue '" + qName2 + "'.");
        }
        String string4 = string3.substring(0, n);
        if (string4.endsWith("]")) {
            throw new IllegalArgumentException("Arrays of arrays are not supported '" + qName2 + "'.");
        }
        qName.setNamespaceURI(string2);
        qName.setLocalPart(string4);
        int n3 = DOMUtils.countKids(element, (short)1);
        String string5 = string3.substring(n + 1, n2);
        if (string5.length() > 0) {
            if (string5.indexOf(44) != -1) {
                throw new IllegalArgumentException("Multi-dimensional arrays are not supported '" + string5 + "'.");
            }
            try {
                int n4 = Integer.parseInt(string5);
                if (n3 != n4) {
                    throw new IllegalArgumentException("Explicit array length is not equal to the number of items '" + n4 + " != " + n3 + "'.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Explicit array length is not a valid integer '" + string5 + "'.");
            }
        }
        Class clazz = xMLJavaMappingRegistry.queryJavaType(qName, string);
        return Array.newInstance(clazz, n3);
    }

    public void marshall(String string, Class clazz, Object object, Object object2, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        nSStack.pushScope();
        String string2 = object != null ? String.valueOf(Array.getLength(object)) : "";
        Class<?> clazz2 = clazz.getComponentType();
        QName qName = xMLJavaMappingRegistry.queryElementType(clazz2, Constants.NS_URI_SOAP_ENC);
        if (object == null) {
            SoapEncUtils.generateNullArray(string, clazz, object2, writer, nSStack, xMLJavaMappingRegistry, qName, string2);
        } else {
            SoapEncUtils.generateArrayHeader(string, clazz, object2, writer, nSStack, xMLJavaMappingRegistry, qName, string2);
            writer.write(StringUtils.lineSeparator);
            int n = Array.getLength(object);
            int n2 = 0;
            while (n2 < n) {
                nSStack.pushScope();
                Object object3 = Array.get(object, n2);
                if (object3 == null) {
                    SoapEncUtils.generateNullStructure(string, clazz2, "item", writer, nSStack, xMLJavaMappingRegistry);
                } else {
                    Class<?> clazz3 = object3.getClass();
                    xMLJavaMappingRegistry.marshall(string, clazz3, object3, "item", writer, nSStack);
                }
                writer.write(StringUtils.lineSeparator);
                nSStack.popScope();
                ++n2;
            }
            writer.write("</" + object2 + '>');
        }
        nSStack.popScope();
    }

    public Bean unmarshall(String string, QName qName, Node node, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException {
        Element element = (Element)node;
        String string2 = element.getTagName();
        QName qName2 = new QName("", "");
        Object object = ArraySerializer.getNewArray(string, element, qName2, xMLJavaMappingRegistry);
        if (SoapEncUtils.isNull(element)) {
            return new Bean(object.getClass(), null);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            String string3 = DOMUtils.getAttributeNS(element2, Constants.NS_URI_SOAP_ENV, Constants.ATTR_ENCODING_STYLE);
            String string4 = string3 != null ? string3 : string;
            QName qName3 = SoapEncUtils.getAttributeValue(element2, Constants.NS_URI_SCHEMA_XSI, Constants.ATTR_TYPE, "array item", false);
            QName qName4 = qName3 != null ? qName3 : qName2;
            Bean bean = xMLJavaMappingRegistry.unmarshall(string4, qName4, element2);
            Array.set(object, n2, bean.value);
            element2 = DOMUtils.getNextSiblingElement(element2);
            ++n2;
        }
        return new Bean(object.getClass(), object);
    }
}

