/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.Utils;
import org.apache.soap.encoding.literalxml.XMLParameterSerializer;
import org.apache.soap.encoding.soapenc.ArraySerializer;
import org.apache.soap.encoding.soapenc.Base64Serializer;
import org.apache.soap.encoding.soapenc.ParameterSerializer;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.encoding.soapenc.VectorSerializer;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPMappingRegistry
extends XMLJavaMappingRegistry {
    private static final String soapEncURI = Constants.NS_URI_SOAP_ENC;
    private static final String schemaURI = Constants.NS_URI_SCHEMA_XSD;
    private static final QName stringQName = new QName(schemaURI, "string");
    private static final QName booleanQName = new QName(schemaURI, "boolean");
    private static final QName doubleQName = new QName(schemaURI, "double");
    private static final QName floatQName = new QName(schemaURI, "float");
    private static final QName longQName = new QName(schemaURI, "long");
    private static final QName intQName = new QName(schemaURI, "int");
    private static final QName shortQName = new QName(schemaURI, "short");
    private static final QName byteQName = new QName(schemaURI, "byte");
    private static final QName arrayQName = new QName(soapEncURI, "Array");
    private final ParameterSerializer paramSer = new ParameterSerializer();
    private final ArraySerializer arraySer = new ArraySerializer();
    private final VectorSerializer vectorSer = new VectorSerializer();
    private final XMLParameterSerializer xmlParamSer = new XMLParameterSerializer();
    static /* synthetic */ Class class$org$apache$soap$rpc$Parameter;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Enumeration;

    public SOAPMappingRegistry() {
        Object object;
        Object object2;
        this.mapTypes(soapEncURI, RPCConstants.Q_ELEM_PARAMETER, class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : (class$org$apache$soap$rpc$Parameter = SOAPMappingRegistry.class$("org.apache.soap.rpc.Parameter")), this.paramSer, this.paramSer);
        this.mapTypes(soapEncURI, arrayQName, null, null, this.arraySer);
        this.mapTypes(Constants.NS_URI_SOAP_ENC, new QName(Constants.NS_URI_SCHEMA_XSD, "ur-type"), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = SOAPMappingRegistry.class$("java.lang.Object")), null, null);
        this.mapTypes(Constants.NS_URI_LITERAL_XML, RPCConstants.Q_ELEM_PARAMETER, class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : (class$org$apache$soap$rpc$Parameter = SOAPMappingRegistry.class$("org.apache.soap.rpc.Parameter")), this.xmlParamSer, this.xmlParamSer);
        try {
            object2 = Class.forName("org.apache.soap.util.xml.XMISerializer");
            object = Class.forName("org.apache.soap.encoding.xmi.XMIParameterSerializer");
            this.mapTypes(Constants.NS_URI_XMI_ENC, null, null, (Serializer)((Class)object2).newInstance(), (Deserializer)((Class)object).newInstance());
            this.mapTypes(Constants.NS_URI_XMI_ENC, null, class$org$apache$soap$rpc$Parameter != null ? class$org$apache$soap$rpc$Parameter : (class$org$apache$soap$rpc$Parameter = SOAPMappingRegistry.class$("org.apache.soap.rpc.Parameter")), (Serializer)((Class)object).newInstance(), null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        object2 = new Serializer(){

            public void marshall(String string, Class clazz, Object object, Object object2, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
                nSStack.pushScope();
                SoapEncUtils.generateStructureHeader(string, clazz, object2, writer, nSStack, xMLJavaMappingRegistry);
                writer.write(String.valueOf(Utils.cleanString(object.toString())) + "</" + object2 + '>');
                nSStack.popScope();
            }
        };
        object = new Deserializer(){

            public Bean unmarshall(String string, QName qName, Node node, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException {
                Element element = (Element)node;
                String string2 = DOMUtils.getChildCharacterData(element);
                if (qName.equals(stringQName)) {
                    return new Bean(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SOAPMappingRegistry.class$("java.lang.String")), string2);
                }
                if (qName.equals(booleanQName)) {
                    return new Bean(Boolean.TYPE, new Boolean(string2));
                }
                if (qName.equals(doubleQName)) {
                    return new Bean(Double.TYPE, new Double(string2));
                }
                if (qName.equals(floatQName)) {
                    return new Bean(Float.TYPE, new Float(string2));
                }
                if (qName.equals(longQName)) {
                    return new Bean(Long.TYPE, new Long(string2));
                }
                if (qName.equals(intQName)) {
                    return new Bean(Integer.TYPE, new Integer(string2));
                }
                if (qName.equals(shortQName)) {
                    return new Bean(Short.TYPE, new Short(string2));
                }
                if (qName.equals(byteQName)) {
                    return new Bean(Byte.TYPE, new Byte(string2));
                }
                throw new IllegalArgumentException("I don't know how to deserialize a '" + qName + "' using encoding style '" + string + "'.");
            }
        };
        this.mapTypes(soapEncURI, stringQName, class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SOAPMappingRegistry.class$("java.lang.String")), (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, booleanQName, class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = SOAPMappingRegistry.class$("java.lang.Boolean")), (Serializer)object2, null);
        this.mapTypes(soapEncURI, booleanQName, Boolean.TYPE, (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, doubleQName, class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = SOAPMappingRegistry.class$("java.lang.Double")), (Serializer)object2, null);
        this.mapTypes(soapEncURI, doubleQName, Double.TYPE, (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, floatQName, class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = SOAPMappingRegistry.class$("java.lang.Float")), (Serializer)object2, null);
        this.mapTypes(soapEncURI, floatQName, Float.TYPE, (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, longQName, class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = SOAPMappingRegistry.class$("java.lang.Long")), (Serializer)object2, null);
        this.mapTypes(soapEncURI, longQName, Long.TYPE, (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, intQName, class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = SOAPMappingRegistry.class$("java.lang.Integer")), (Serializer)object2, null);
        this.mapTypes(soapEncURI, intQName, Integer.TYPE, (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, shortQName, class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = SOAPMappingRegistry.class$("java.lang.Short")), (Serializer)object2, null);
        this.mapTypes(soapEncURI, shortQName, Short.TYPE, (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, byteQName, class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = SOAPMappingRegistry.class$("java.lang.Byte")), (Serializer)object2, null);
        this.mapTypes(soapEncURI, byteQName, Byte.TYPE, (Serializer)object2, (Deserializer)object);
        this.mapTypes(soapEncURI, null, class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = SOAPMappingRegistry.class$("java.util.Vector")), this.vectorSer, null);
        Base64Serializer base64Serializer = new Base64Serializer();
        QName qName = new QName(soapEncURI, "base64");
        this.mapTypes(soapEncURI, qName, array$B != null ? array$B : (array$B = SOAPMappingRegistry.class$("[B")), base64Serializer, base64Serializer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public QName queryElementType(Class clazz, String string) throws IllegalArgumentException {
        try {
            return super.queryElementType(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (clazz != null && (clazz.isArray() || clazz.equals(class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = SOAPMappingRegistry.class$("java.util.Vector"))) || (class$java$util$Enumeration != null ? class$java$util$Enumeration : (class$java$util$Enumeration = SOAPMappingRegistry.class$("java.util.Enumeration"))).isAssignableFrom(clazz)) && string != null && string.equals(soapEncURI)) {
                return arrayQName;
            }
            throw illegalArgumentException;
        }
    }

    public Serializer querySerializer(Class clazz, String string) throws IllegalArgumentException {
        try {
            return super.querySerializer(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (clazz != null && string != null && string.equals(soapEncURI)) {
                if (clazz.isArray()) {
                    return this.arraySer;
                }
                if ((class$java$util$Enumeration != null ? class$java$util$Enumeration : (class$java$util$Enumeration = SOAPMappingRegistry.class$("java.util.Enumeration"))).isAssignableFrom(clazz)) {
                    return this.vectorSer;
                }
            }
            throw illegalArgumentException;
        }
    }
}

