/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Constants;
import org.apache.soap.Utils;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Header {
    private Vector headerEntries = null;
    private AttributeHandler attrHandler = new AttributeHandler();

    public void declareNamespace(String string, String string2) {
        this.attrHandler.declareNamespace(string, string2);
    }

    public String getAttribute(QName qName) {
        return this.attrHandler.getAttribute(qName);
    }

    public Vector getHeaderEntries() {
        return this.headerEntries;
    }

    public void marshall(Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        this.attrHandler.populateNSStack(nSStack);
        String string = this.attrHandler.getUniquePrefixFromURI(Constants.NS_URI_SOAP_ENV, Constants.NS_PRE_SOAP_ENV, nSStack);
        if (this.headerEntries != null) {
            writer.write(String.valueOf('<') + string + ':' + Constants.ELEM_HEADER);
            this.attrHandler.marshall(writer);
            writer.write(String.valueOf('>') + StringUtils.lineSeparator);
            Enumeration enumeration = this.headerEntries.elements();
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                Utils.marshallNode(element, writer);
                writer.write(StringUtils.lineSeparator);
            }
            writer.write("</" + string + ':' + Constants.ELEM_HEADER + '>' + StringUtils.lineSeparator);
        }
        nSStack.popScope();
    }

    public void removeAttribute(QName qName) {
        this.attrHandler.removeAttribute(qName);
    }

    public void setAttribute(QName qName, String string) {
        this.attrHandler.setAttribute(qName, string);
    }

    public void setHeaderEntries(Vector vector) {
        this.headerEntries = vector;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[Attributes=" + this.attrHandler + "] " + "[HeaderEntries={");
        if (this.headerEntries != null) {
            int n = 0;
            while (n < this.headerEntries.size()) {
                if (n > 0) {
                    printWriter.print(", ");
                }
                printWriter.print("[" + this.headerEntries.elementAt(n) + "]");
                ++n;
            }
        }
        printWriter.print("}]");
        return stringWriter.toString();
    }

    public static Header unmarshall(Node node) throws IllegalArgumentException {
        Element element = (Element)node;
        Header header = new Header();
        Vector<Element> vector = new Vector<Element>();
        header.attrHandler = AttributeHandler.unmarshall(element);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            vector.addElement(element2);
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        header.setHeaderEntries(vector);
        return header;
    }
}

