/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Constants;
import org.apache.soap.Utils;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Fault {
    private String faultCode = null;
    private String faultString = null;
    private String faultActorURI = null;
    private Vector detailEntries = null;
    private Vector faultEntries = null;
    private AttributeHandler attrHandler = new AttributeHandler();

    public void declareNamespace(String string, String string2) {
        this.attrHandler.declareNamespace(string, string2);
    }

    public String getAttribute(QName qName) {
        return this.attrHandler.getAttribute(qName);
    }

    public Vector getDetailEntries() {
        return this.detailEntries;
    }

    public String getFaultActorURI() {
        return this.faultActorURI;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public Vector getFaultEntries() {
        return this.faultEntries;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void marshall(String string, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        Element element;
        Enumeration enumeration;
        this.attrHandler.populateNSStack(nSStack);
        String string2 = this.getFaultCode();
        String string3 = this.getFaultString();
        String string4 = this.getFaultActorURI();
        Vector vector = this.getDetailEntries();
        Vector vector2 = this.getFaultEntries();
        String string5 = this.attrHandler.getUniquePrefixFromURI(Constants.NS_URI_SOAP_ENV, Constants.NS_PRE_SOAP_ENV, nSStack);
        writer.write(String.valueOf('<') + string5 + ':' + Constants.ELEM_FAULT);
        this.attrHandler.marshall(writer);
        writer.write(String.valueOf('>') + StringUtils.lineSeparator + '<' + Constants.ELEM_FAULT_CODE + '>' + string2 + "</" + Constants.ELEM_FAULT_CODE + '>' + StringUtils.lineSeparator + '<' + Constants.ELEM_FAULT_STRING + '>' + string3 + "</" + Constants.ELEM_FAULT_STRING + '>' + StringUtils.lineSeparator);
        if (string4 != null) {
            writer.write(String.valueOf('<') + Constants.ELEM_FAULT_ACTOR + '>' + string4 + "</" + Constants.ELEM_FAULT_ACTOR + '>' + StringUtils.lineSeparator);
        }
        if (vector != null) {
            writer.write(String.valueOf('<') + Constants.ELEM_DETAIL + '>' + StringUtils.lineSeparator);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                element = (Element)enumeration.nextElement();
                Utils.marshallNode(element, writer);
                writer.write(StringUtils.lineSeparator);
            }
            writer.write("</" + Constants.ELEM_DETAIL + '>' + StringUtils.lineSeparator);
        }
        if (vector2 != null) {
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                element = (Element)enumeration.nextElement();
                Utils.marshallNode(element, writer);
                writer.write(StringUtils.lineSeparator);
            }
        }
        writer.write("</" + string5 + ':' + Constants.ELEM_FAULT + '>' + StringUtils.lineSeparator);
        nSStack.popScope();
    }

    public void removeAttribute(QName qName) {
        this.attrHandler.removeAttribute(qName);
    }

    public void setAttribute(QName qName, String string) {
        this.attrHandler.setAttribute(qName, string);
    }

    public void setDetailEntries(Vector vector) {
        this.detailEntries = vector;
    }

    public void setFaultActorURI(String string) {
        this.faultActorURI = string;
    }

    public void setFaultCode(String string) {
        this.faultCode = string;
    }

    public void setFaultEntries(Vector vector) {
        this.faultEntries = vector;
    }

    public void setFaultString(String string) {
        this.faultString = string;
    }

    public String toString() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[Attributes=" + this.attrHandler + "] " + "[faultCode=" + this.faultCode + "] " + "[faultString=" + this.faultString + "] " + "[faultActorURI=" + this.faultActorURI + "] " + "[DetailEntries=");
        if (this.detailEntries != null) {
            printWriter.println();
            n = 0;
            while (n < this.detailEntries.size()) {
                printWriter.println("[(" + n + ")=" + DOM2Writer.nodeToString((Element)this.detailEntries.elementAt(n)) + "]");
                ++n;
            }
        }
        printWriter.print("] [FaultEntries=");
        if (this.faultEntries != null) {
            printWriter.println();
            n = 0;
            while (n < this.faultEntries.size()) {
                printWriter.println("[(" + n + ")=" + DOM2Writer.nodeToString((Element)this.faultEntries.elementAt(n)) + "]");
                ++n;
            }
        }
        printWriter.print("]");
        return stringWriter.toString();
    }

    public static Fault unmarshall(String string, Node node, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException {
        Element element = (Element)node;
        Fault fault = new Fault();
        if (Constants.Q_ELEM_FAULT.matches(element)) {
            Object object;
            Object object2;
            Element element2 = null;
            Element element3 = null;
            Element element4 = null;
            Element element5 = null;
            Vector<Element> vector = new Vector<Element>();
            Element element6 = DOMUtils.getFirstChildElement(element);
            fault.attrHandler = AttributeHandler.unmarshall(element);
            while (element6 != null) {
                object2 = element6.getNamespaceURI();
                object = element6.getLocalName();
                if (object == null) {
                    object = element6.getTagName();
                }
                if (object2 == null || ((String)object2).equals(Constants.NS_URI_SOAP_ENV)) {
                    if (((String)object).equals(Constants.ELEM_FAULT_CODE)) {
                        element2 = element6;
                    } else if (((String)object).equals(Constants.ELEM_FAULT_STRING)) {
                        element3 = element6;
                    } else if (((String)object).equals(Constants.ELEM_FAULT_ACTOR)) {
                        element4 = element6;
                    } else if (((String)object).equals(Constants.ELEM_DETAIL)) {
                        element5 = element6;
                    } else {
                        vector.addElement(element6);
                    }
                } else {
                    vector.addElement(element6);
                }
                element6 = DOMUtils.getNextSiblingElement(element6);
            }
            if (element2 == null) {
                throw new IllegalArgumentException("A '" + Constants.Q_ELEM_FAULT + "' element must contain a: '" + Constants.ELEM_FAULT_CODE + "' element.");
            }
            object2 = DOMUtils.getChildCharacterData(element2);
            fault.setFaultCode((String)object2);
            if (element3 == null) {
                throw new IllegalArgumentException("A '" + Constants.Q_ELEM_FAULT + "' element must contain a: '" + Constants.ELEM_FAULT_STRING + "' element.");
            }
            object2 = DOMUtils.getChildCharacterData(element3);
            fault.setFaultString((String)object2);
            if (element4 != null) {
                object2 = DOMUtils.getChildCharacterData(element4);
                fault.setFaultActorURI((String)object2);
            }
            if (element5 != null) {
                object2 = new Vector();
                object = DOMUtils.getFirstChildElement(element5);
                while (object != null) {
                    ((Vector)object2).addElement(object);
                    object = DOMUtils.getNextSiblingElement((Element)object);
                }
                fault.setDetailEntries((Vector)object2);
            }
            if (vector.size() > 0) {
                fault.setFaultEntries(vector);
            }
        } else {
            throw new IllegalArgumentException("Root element of a SOAP Fault must be: '" + Constants.Q_ELEM_FAULT + "'.");
        }
        return fault;
    }
}

