/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Header;
import org.apache.soap.Utils;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Envelope {
    private Header header = null;
    private Body body = null;
    private Vector envelopeEntries = null;
    private AttributeHandler attrHandler = new AttributeHandler();

    public Envelope() {
        this.declareNamespace(Constants.NS_PRE_SOAP_ENV, Constants.NS_URI_SOAP_ENV);
        this.declareNamespace(Constants.NS_PRE_SCHEMA_XSI, Constants.NS_URI_SCHEMA_XSI);
        this.declareNamespace(Constants.NS_PRE_SCHEMA_XSD, Constants.NS_URI_SCHEMA_XSD);
    }

    public void declareNamespace(String string, String string2) {
        this.attrHandler.declareNamespace(string, string2);
    }

    public String getAttribute(QName qName) {
        return this.attrHandler.getAttribute(qName);
    }

    public Body getBody() {
        return this.body;
    }

    public Vector getEnvelopeEntries() {
        return this.envelopeEntries;
    }

    public Header getHeader() {
        return this.header;
    }

    public void marshall(Writer writer, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        NSStack nSStack = new NSStack();
        this.attrHandler.populateNSStack(nSStack);
        Header header = this.getHeader();
        Body body = this.getBody();
        Vector vector = this.getEnvelopeEntries();
        String string = this.getAttribute(new QName(Constants.NS_URI_SOAP_ENV, Constants.ATTR_ENCODING_STYLE));
        String string2 = this.attrHandler.getUniquePrefixFromURI(Constants.NS_URI_SOAP_ENV, Constants.NS_PRE_SOAP_ENV, nSStack);
        writer.write(String.valueOf('<') + string2 + ':' + Constants.ELEM_ENVELOPE);
        this.attrHandler.marshall(writer);
        writer.write(String.valueOf('>') + StringUtils.lineSeparator);
        if (header != null) {
            header.marshall(writer, nSStack, xMLJavaMappingRegistry);
        }
        if (body == null) {
            throw new IllegalArgumentException("An '" + Constants.Q_ELEM_ENVELOPE + "' must contain a: '" + Constants.Q_ELEM_BODY + "'.");
        }
        body.marshall(string, writer, nSStack, xMLJavaMappingRegistry);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                Utils.marshallNode(element, writer);
                writer.write(StringUtils.lineSeparator);
            }
        }
        writer.write("</" + string2 + ':' + Constants.ELEM_ENVELOPE + '>');
    }

    public void removeAttribute(QName qName) {
        this.attrHandler.removeAttribute(qName);
    }

    public void setAttribute(QName qName, String string) {
        this.attrHandler.setAttribute(qName, string);
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public void setEnvelopeEntries(Vector vector) {
        this.envelopeEntries = vector;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[Attributes=" + this.attrHandler + "] " + "[Header=" + this.header + "] " + "[Body=" + this.body + "] " + "[EnvelopeEntries=");
        if (this.envelopeEntries != null) {
            printWriter.println();
            int n = 0;
            while (n < this.envelopeEntries.size()) {
                printWriter.println("[(" + n + ")=" + DOM2Writer.nodeToString((Element)this.envelopeEntries.elementAt(n)) + "]");
                ++n;
            }
        }
        printWriter.print("]");
        return stringWriter.toString();
    }

    public static Envelope unmarshall(Node node) throws IllegalArgumentException {
        Element element = (Element)node;
        Envelope envelope = new Envelope();
        if (Constants.Q_ELEM_ENVELOPE.matches(element)) {
            Vector<Element> vector;
            envelope.attrHandler = AttributeHandler.unmarshall(element);
            Element element2 = null;
            Element element3 = null;
            Element element4 = DOMUtils.getFirstChildElement(element);
            if (Constants.Q_ELEM_HEADER.matches(element4)) {
                element2 = element4;
                element4 = DOMUtils.getNextSiblingElement(element4);
            }
            if (Constants.Q_ELEM_BODY.matches(element4)) {
                element3 = element4;
                element4 = DOMUtils.getNextSiblingElement(element4);
            }
            if (element2 != null) {
                vector = Header.unmarshall(element2);
                envelope.setHeader((Header)((Object)vector));
            }
            if (element3 == null) {
                throw new IllegalArgumentException("An '" + Constants.Q_ELEM_ENVELOPE + "' element must contain a: '" + Constants.Q_ELEM_BODY + "' element.");
            }
            vector = Body.unmarshall(element3);
            envelope.setBody((Body)((Object)vector));
            if (element4 != null) {
                vector = new Vector<Element>();
                while (element4 != null) {
                    vector.addElement(element4);
                    element4 = DOMUtils.getNextSiblingElement(element4);
                }
                envelope.setEnvelopeEntries(vector);
            }
        } else {
            String string = element.getLocalName();
            if (string != null && string.equals(Constants.ELEM_ENVELOPE)) {
                throw new IllegalArgumentException(Constants.ERR_MSG_VERSION_MISMATCH);
            }
            throw new IllegalArgumentException("Root element of a SOAP message must be: '" + Constants.Q_ELEM_ENVELOPE + "'.");
        }
        return envelope;
    }
}

