/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.soap.AttributeHandler;
import org.apache.soap.Constants;
import org.apache.soap.util.Bean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Body {
    private Vector bodyEntries = null;
    private AttributeHandler attrHandler = new AttributeHandler();
    static /* synthetic */ Class class$org$apache$soap$util$xml$Serializer;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void declareNamespace(String string, String string2) {
        this.attrHandler.declareNamespace(string, string2);
    }

    public String getAttribute(QName qName) {
        return this.attrHandler.getAttribute(qName);
    }

    public Vector getBodyEntries() {
        return this.bodyEntries;
    }

    public void marshall(String string, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        this.attrHandler.populateNSStack(nSStack);
        String string2 = this.getAttribute(new QName(Constants.NS_URI_SOAP_ENV, Constants.ATTR_ENCODING_STYLE));
        String string3 = string2 != null ? string2 : string;
        String string4 = this.attrHandler.getUniquePrefixFromURI(Constants.NS_URI_SOAP_ENV, Constants.NS_PRE_SOAP_ENV, nSStack);
        writer.write(String.valueOf('<') + string4 + ':' + Constants.ELEM_BODY);
        this.attrHandler.marshall(writer);
        writer.write(String.valueOf('>') + StringUtils.lineSeparator);
        if (this.bodyEntries != null) {
            Enumeration enumeration = this.bodyEntries.elements();
            while (enumeration.hasMoreElements()) {
                Bean bean = (Bean)enumeration.nextElement();
                if ((class$org$apache$soap$util$xml$Serializer != null ? class$org$apache$soap$util$xml$Serializer : Body.class$("org.apache.soap.util.xml.Serializer")).isAssignableFrom(bean.type)) {
                    ((Serializer)bean.value).marshall(string3, bean.type, bean.value, null, writer, nSStack, xMLJavaMappingRegistry);
                    continue;
                }
                throw new IllegalArgumentException("Body entries must implement the Serializer interface.");
            }
        }
        writer.write("</" + string4 + ':' + Constants.ELEM_BODY + '>' + StringUtils.lineSeparator);
        nSStack.popScope();
    }

    public void removeAttribute(QName qName) {
        this.attrHandler.removeAttribute(qName);
    }

    public void setAttribute(QName qName, String string) {
        this.attrHandler.setAttribute(qName, string);
    }

    public void setBodyEntries(Vector vector) {
        this.bodyEntries = vector;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[Attributes=" + this.attrHandler + "] " + "[BodyEntries=");
        if (this.bodyEntries != null) {
            printWriter.println();
            int n = 0;
            while (n < this.bodyEntries.size()) {
                printWriter.println("[(" + n + ")=" + this.bodyEntries.elementAt(n) + "]");
                ++n;
            }
        }
        printWriter.print("]");
        return stringWriter.toString();
    }

    public static Body unmarshall(Node node) throws IllegalArgumentException {
        Element element = (Element)node;
        Body body = new Body();
        Vector<Element> vector = new Vector<Element>();
        body.attrHandler = AttributeHandler.unmarshall(element);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            vector.addElement(element2);
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        body.setBodyEntries(vector);
        return body;
    }
}

