/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class AttributeHandler {
    private Hashtable attributes = new Hashtable();
    private Hashtable namespaceURIs2Prefixes = new Hashtable();
    private int nsPrefixIndex = 0;

    public AttributeHandler() {
        this.namespaceURIs2Prefixes.put(Constants.NS_URI_XMLNS, Constants.NS_PRE_XMLNS);
    }

    public void declareNamespace(String string, String string2) {
        this.setAttribute(new QName(Constants.NS_URI_XMLNS, string), string2);
    }

    private void generateNSDeclarations() {
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            QName qName = (QName)enumeration.nextElement();
            this.getPrefixFromURI(qName.getNamespaceURI());
        }
    }

    public String getAttribute(QName qName) {
        return (String)this.attributes.get(qName);
    }

    private Enumeration getAttributeQNames() {
        this.generateNSDeclarations();
        return this.attributes.keys();
    }

    private String getPrefixFromURI(String string) {
        String string2 = (String)this.namespaceURIs2Prefixes.get(string);
        if (string2 == null) {
            string2 = "ns" + this.nsPrefixIndex++;
            this.setAttribute(new QName(Constants.NS_URI_XMLNS, string2), string);
        }
        return string2;
    }

    public String getUniquePrefixFromURI(String string, String string2, NSStack nSStack) {
        String string3 = nSStack.getPrefixFromURI(string);
        if (string3 == null) {
            int n = 0;
            if (string2 == null) {
                string2 = "ns";
                ++n;
            }
            while (string3 == null) {
                String string4 = String.valueOf(string2) + (n > 0 ? String.valueOf(n) : "");
                if (nSStack.getURIFromPrefix(string4) == null) {
                    nSStack.popScope();
                    this.declareNamespace(string4, string);
                    this.populateNSStack(nSStack);
                    string3 = nSStack.getPrefixFromURI(string);
                    continue;
                }
                ++n;
            }
        }
        return string3;
    }

    public void marshall(Writer writer) throws IllegalArgumentException, IOException {
        Enumeration enumeration = this.getAttributeQNames();
        while (enumeration.hasMoreElements()) {
            QName qName = (QName)enumeration.nextElement();
            writer.write(String.valueOf(' ') + this.getPrefixFromURI(qName.getNamespaceURI()) + ':' + qName.getLocalPart() + "=\"" + this.getAttribute(qName) + '\"');
        }
    }

    public void populateNSStack(NSStack nSStack) {
        this.generateNSDeclarations();
        nSStack.pushScope();
        Enumeration enumeration = this.namespaceURIs2Prefixes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getPrefixFromURI(string);
            nSStack.addNSDeclaration(string2, string);
        }
    }

    public void removeAttribute(QName qName) {
        this.attributes.remove(qName);
    }

    public void setAttribute(QName qName, String string) {
        this.attributes.put(qName, string);
        if (qName.getNamespaceURI().equals(Constants.NS_URI_XMLNS)) {
            this.namespaceURIs2Prefixes.put(string, qName.getLocalPart());
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            stringWriter.write("{");
            this.marshall(stringWriter);
            stringWriter.write("}");
        }
        catch (Exception exception) {}
        return stringWriter.toString();
    }

    public static AttributeHandler unmarshall(Node node) throws IllegalArgumentException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        AttributeHandler attributeHandler = new AttributeHandler();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = attr.getNamespaceURI();
            String string2 = attr.getLocalName();
            String string3 = attr.getValue();
            attributeHandler.setAttribute(new QName(string, string2), string3);
            ++n2;
        }
        return attributeHandler;
    }
}

