<?xml version="1.0"?> 

<!--

$Id: rss-news.xsl,v 1.2 2002/03/23 02:41:06 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Take our news.rss file and change it into news.xml for use with anakia.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                version="1.0">

    <xsl:template match="/rdf:RDF">

        <document>
            
            <properties>
                <title>NEWS</title>
                <author email="burton@openprivacy.org">Reptile Documentation Team</author>
            </properties>
            
            <body>

                <section name="News">

                    <xsl:apply-templates select="rss:item"/>

                </section>

                <section name="Syndicate">

                    <p>
                        This file is also available for <a href="news.rss">syndication as RSS.</a>
                    </p>

                </section>
                
            </body>

        </document>
                
    </xsl:template>
    
    <xsl:template match="rss:item">

        <p>
            <h3>
                <xsl:value-of select="dc:date"/> - <a href="{./rss:link}"><xsl:value-of select="rss:title"/></a>
            </h3>
        </p>
        
        <p>
        
            <xsl:value-of select="rss:description"/>

        </p>
        
        <hr/>
        
    </xsl:template>
        
</xsl:stylesheet>
