<?xml version="1.0"?> 

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:im="http://purl.org/rss/1.0/item-images/" 
                xmlns:record="http://records.sourceforge.net/schemas/rss-meta-module/"
                xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:content="http://purl.org/rss/1.0/modules/content/"
                xmlns:redirect="xalan://org.apache.xalan.xslt.extensions.Redirect"
                exclude-result-prefixes="rdf dc rss im record xhtml"
                extension-element-prefixes="redirect"
                version="1.0">

    <!-- Create RSS permalink items -->
    <xsl:template name="permalink">

        <xsl:param name="permalink"/>
        <xsl:param name="printlink"/>

        <redirect:write select="$permalink">

            <xsl:comment>#include virtual="/website/top-before-title.shtml"</xsl:comment>
            <title><xsl:value-of select="./rss:title"/></title>
            <xsl:comment>#include virtual="/website/top-after-title.shtml"</xsl:comment>

            <xsl:call-template name="header"/>

            <xsl:call-template name="item"/>

            <a href="http://www.peerfear.org/rss/{$printlink}"
               style="font-family: Arial, Helvetica, sans-serif;color: #000000;font-weight: bold;">
                Print Article</a>
            
            <xsl:if test="following-sibling::rss:item/rss:title != ''">

                <xsl:variable name="nextlink">
            
                    <xsl:value-of select="concat( 'permalink/', following-sibling::rss:item/@record:uuid, '.shtml' )"/>

                </xsl:variable>

                <p align="center">

                    <b> Next: </b>
                    
                    <a href="http://www.peerfear.org/rss/{$nextlink}"
                       style="font-family: Arial, Helvetica, sans-serif;color: #000000;font-weight: bold; margin: 5;">
                        <xsl:value-of select="following-sibling::rss:item/rss:title"/>
                    </a>

                </p>

            </xsl:if>

            <xsl:comment>#include virtual="/website/bottom.shtml"</xsl:comment>
            
        </redirect:write>

    </xsl:template>

    <xsl:template name="printlink">

        <xsl:param name="permalink"/>
        <xsl:param name="printlink"/>

        <redirect:write select="$printlink">

            <html>
                <head>

                    <link title="Style"
                          href="/website/style/default.css"
                          type="text/css"
                          rel="stylesheet"/>

                    <title><xsl:value-of select="./rss:title"/></title>

                </head>

                <body bgcolor="white" text="#000000" link="#000000" vlink="#000000" alink="#000000">

                    <xsl:call-template name="header"/>

                    <xsl:call-template name="item"/>

                    <xsl:if test="following-sibling::rss:item/rss:title != ''">

                        <xsl:variable name="nextlink">
                    
                            <xsl:value-of select="concat( 'permalink/', following-sibling::rss:item/@record:uuid, '.shtml' )"/>

                        </xsl:variable>

                        <p align="center">

                            <b> Next: </b>
                            
                            <a href="http://www.peerfear.org/rss/{$nextlink}"
                               style="font-family: Arial, Helvetica, sans-serif;color: #000000;font-weight: bold; margin: 5;">
                                <xsl:value-of select="following-sibling::rss:item/rss:title"/>
                            </a>

                        </p>

                    </xsl:if>

                </body>

            </html>
                    
        </redirect:write>

    </xsl:template>

    <xsl:template name="item">

        <img src="{im:image}" align="right" hspace="10" vspace="0"/>

        <a href="{rss:link}" style="font-family: Arial, Helvetica, sans-serif;color: #0033CC;font-weight: bold;">
            <xsl:value-of select="./rss:title"/>
        </a>

        <br/>

        <span class="timestamp">
            Posted on <xsl:value-of select="./dc:date"/>
        </span>

        <xsl:comment>BEGIN ARTICLE BODY</xsl:comment>
        
        <xsl:choose>

            <xsl:when test="count( content:items ) = 0">

                <xsl:apply-templates select="./rss:description"/>

            </xsl:when>

            <xsl:otherwise>

                <!-- ok... apply mod-content template  which should just be a copy -->

                <xsl:apply-templates select="./content:items/rdf:Bag/rdf:li/content:item/rdf:value"/>

            </xsl:otherwise>

        </xsl:choose>

        <xsl:comment>END ARTICLE BODY</xsl:comment>

    </xsl:template>

    <xsl:template name="item-separator">

        <xsl:param name="permalink"/>
        <xsl:param name="printlink"/>

        <a href="{$permalink}"
           style="font-family: Arial, Helvetica, sans-serif;color: #000000;font-weight: bold;">Read More</a>

        <a href="{$printlink}"
           style="font-family: Arial, Helvetica, sans-serif;color: #000000;font-weight: bold; margin: 5;">
            Print Article</a>

        <br/>
        
        <br clear="all"/>

        <hr style="border:1px #ff6500 solid; margin-bottom: 6;"/>

    </xsl:template>

    <xsl:template name="header">

        <table cellpadding="0" cellmargin="0" cellspacing="0" width="100%">

            <td class="nomargin">

                <h4>News: ( <a href="/rss/index-print.shtml">Print</a> )</h4> 

            </td>

            <td class="nomargin">

                <a href="http://www.peerfear.org/rss/index.rss" type="application/rss+xml">
                    <img src="/rss/images/xml.gif" border="0" align="right"/>
                </a>

            </td>

        </table>

        <br/>

    </xsl:template>

    <!-- Now we need to perform identity transformations on all additional nodes -->
    <xsl:template match="@*|node()">

        <xsl:copy-of select=".">
        </xsl:copy-of>

    </xsl:template>

</xsl:stylesheet>

