<?xml version="1.0"?> 

<!-- 

Stylesheet which accepts an RSS 1.0 input file and outputs a section file
for use within Anakia.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:im="http://purl.org/rss/1.0/item-images/" 
                xmlns:record="http://records.sourceforge.net/schemas/rss-meta-module/"
                xmlns:content="http://purl.org/rss/1.0/modules/content/"
                xmlns:redirect="xalan://org.apache.xalan.xslt.extensions.Redirect"
                xmlns:xhtml="http://www.w3.org/1999/xhtml" 
                exclude-result-prefixes="rdf dc rss im record xhtml content"
                extension-element-prefixes="redirect"
                version="1.0">

     <xsl:output indent="no" 
                 method="xml"
                 omit-xml-declaration="no"/>

    <xsl:template match="/subjects">

        <rdf:RDF>
            
            <xsl:apply-templates select="entry">
                
                <xsl:sort select="@name" order="ascending"/>
                
            </xsl:apply-templates>

        </rdf:RDF>
            
    </xsl:template>

    <xsl:template match="/subjects/entry">

        <xsl:apply-templates select="document( @href )/rdf:RDF/rss:item"/>

    </xsl:template>

    <!-- Now we need to perform identity transformations on all additional nodes -->
    <xsl:template match="@*|node()">

        <xsl:copy-of select=".">
        </xsl:copy-of>

    </xsl:template>

</xsl:stylesheet>

