<?xml version="1.0"?> 

<!-- 

Stylesheet which accepts an RSS 1.0 input file and outputs a section file
for use within Anakia.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:im="http://purl.org/rss/1.0/item-images/" 
                xmlns:record="http://records.sourceforge.net/schemas/rss-meta-module/"
                xmlns:content="http://purl.org/rss/1.0/modules/content/"
                xmlns:redirect="xalan://org.apache.xalan.xslt.extensions.Redirect"
                xmlns:xhtml="http://www.w3.org/1999/xhtml" 
                exclude-result-prefixes="rdf dc rss im record xhtml content"
                extension-element-prefixes="redirect"
                version="1.0">

     <xsl:output indent="no" 
                 method="xml"
                 omit-xml-declaration="yes"/>

    <xsl:include href="rss-1.0-templates.xsl"/>

    <xsl:param name="sitebase" select="'http://www.peerfear.org/rss/'"/>

    <xsl:template match="/rdf:RDF">

        <document>

            <properties>
                <title>Reptile News</title>
                <author email="burton@openprivacy.org">Reptile Documentation Team</author>
            </properties>

            <body>

                <section name="News">

                    <xsl:apply-templates select="rss:channel"/>
                    
                    <xsl:apply-templates select="rss:item[position() &lt;= 20]">
                        
                        <xsl:sort select="@record:uuid" order="descending"/>
                        
                    </xsl:apply-templates>

                </section>

            </body>

        </document>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:channel">
    </xsl:template>
    
    <xsl:template match="/rdf:RDF/rss:item">

        <xsl:variable name="permalink">

            <xsl:choose>

                <xsl:when test="count( @record:uuid ) = 1">

                    <xsl:value-of select="concat( $sitebase, 'permalink/', @record:uuid, '.shtml' )"/>
                    
                </xsl:when>

                <xsl:otherwise>

                    <xsl:value-of select="concat( $sitebase, 'permalink/', position(), '.shtml' )"/>

                </xsl:otherwise>

            </xsl:choose>

        </xsl:variable>

        <xsl:variable name="printlink">

            <xsl:choose>

                <xsl:when test="count( @record:uuid ) = 1">

                    <xsl:value-of select="concat( $sitebase, 'permalink/', @record:uuid, '-print.shtml' )"/>
                    
                </xsl:when>

                <xsl:otherwise>

                    <xsl:value-of select="concat( $sitebase, 'permalink/', position(), '-print.shtml' )"/>

                </xsl:otherwise>

            </xsl:choose>

        </xsl:variable>

        <xsl:call-template name="item"/>

        <xsl:call-template name="item-separator">

            <xsl:with-param name="permalink" select="$permalink"/>
            <xsl:with-param name="printlink" select="$printlink"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:item/rss:description">

        <p>
            <xsl:value-of select="."/>
        </p>          

    </xsl:template>    

    <xsl:template match="/rdf:RDF/rss:item/content:items/rdf:Bag/rdf:li/content:item/rdf:value">

        <!-- now we should resort to a copy -->
        
        <xsl:apply-templates/>

    </xsl:template>

</xsl:stylesheet>

