<?xml version="1.0"?> 

<!--

$Id: html.xsl,v 1.2 2002/04/10 08:34:13 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet provide a template for copying XML for every match into the
result.

TODO:

     - include a section which explains why an identity system is needed

     - 
     
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                version="1.0">

    <xsl:template match="/document">

        <html>

            <body>

                <h1><xsl:value-of select="properties/title"/></h1>
                
                <xsl:apply-templates select="./body/section"/>

            </body>

        </html>
                
    </xsl:template>
    
    <xsl:template match="/document/body/section">

        <p>
            <h2>
                <xsl:value-of select="@name"/>
            </h2>
        </p>

        <xsl:apply-templates/>
        
    </xsl:template>

    <xsl:template match="/document/body/subsection">

        <p>
            <h3>
                <xsl:value-of select="@name"/>
            </h3>
        </p>

        <xsl:apply-templates/>
        
    </xsl:template>

    <!-- Now we need to perform identity transformations on all additional nodes -->
    <xsl:template match="@*|node()">

        <xsl:copy>

            <xsl:apply-templates select="@*|node()"/>

        </xsl:copy>

    </xsl:template>
    
</xsl:stylesheet>
