<?xml version="1.0"?> 

<!--

$Id: mozilla-advanced-search.xsl,v 1.15 2002/02/06 07:28:21 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                xmlns:results="http://schemas.openprivacy.org/reptile/search-results"
                xmlns:channel-search="xalan://org.openprivacy.reptile.extensions.om.ChannelSearchExtension"
                xmlns:channels="xalan://org.openprivacy.reptile.extensions.om.ChannelExtension"
                extension-element-prefixes="channel-search channels"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.search.query" select="''"/>

    <xsl:param name="reptile.search.type" select="'byTitle'"/>

    <!-- Generate a for for advanced search. -->
    <xsl:template name="advanced-search">

        <blockquote>

            <img src="/reptile/images/search.png" align="right" vspace="10" hspace="10"/>

            <fieldset>

            <legend>Search <channels:count/> channels: </legend>

            <form method="get" action="{$reptile.home.location}">

                <table width="300">

                    <tr>

                    <td nowrap="true" valign="middle">

                    <b>Search for: </b>
1
                    </td>

                    <td valign="middle">

                    <input name="reptile.search.query" type="text">

                        <xsl:attribute name="value">

                            <xsl:value-of select="$reptile.search.query"/>

                        </xsl:attribute>

                    </input>

                    </td>       
                    
                    </tr>

                    <tr>

                    <td nowrap="true" valign="middle">

                    <b> by: </b>

                    </td>

                    <td valign="middle">

                    <select name="reptile.search.type">

                        <xsl:call-template name="create-search-type-option">

                            <xsl:with-param name="type">byTitleAndDescription</xsl:with-param>

                        </xsl:call-template>

                        <xsl:call-template name="create-search-type-option">

                            <xsl:with-param name="type">byTitle</xsl:with-param>

                        </xsl:call-template>

                        <xsl:call-template name="create-search-type-option">

                            <xsl:with-param name="type">byDescription</xsl:with-param>

                        </xsl:call-template>

                    </select>

                    </td>

                    </tr>

                </table>

                <input type="hidden" name="reptile.sequence.name" value="urn:search/channels"/>

                <input type="hidden" name="reptile.layer" value="Search Results"/>

            </form>

            </fieldset>

        </blockquote>

    </xsl:template>
    
</xsl:stylesheet>

