<?xml version="1.0"?> 

<!--

$Id: execute-channel-search.xsl,v 1.1 2001/12/24 01:14:10 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                xmlns:results="http://schemas.openprivacy.org/reptile/search-results"
                xmlns:channel-search="xalan://org.openprivacy.reptile.extensions.om.ChannelSearchExtension"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                extension-element-prefixes="channel-search"
                version="1.0">

    <xsl:output indent="yes" 
                encoding="ISO-8859-1"/>

<!--                omit-xml-declaration="yes" -->

    <xsl:param name="reptile.search.query" select="''"/>

    <xsl:param name="reptile.search.type" select="'byTitleAndDescription'"/>

    <xsl:template match="/bootstrap:bootstrap">
    
        <results:search-results>

            <xsl:choose>

                <xsl:when test="$reptile.search.query = ''">

                    <error:error type="error">

                        No query specified.

                    </error:error>
                
                </xsl:when>

                <xsl:when test="$reptile.search.type = 'byTitle'">

                    <channel-search:byTitle query="%{$reptile.search.query}%"/>

                </xsl:when>

                <xsl:when test="$reptile.search.type = 'byDescription'">

                    <channel-search:byDescription query="%{$reptile.search.query}%"/>

                </xsl:when>

                <xsl:otherwise>

                    <channel-search:byTitleAndDescription query="%{$reptile.search.query}%"/>

                </xsl:otherwise>

            </xsl:choose>

        </results:search-results>

    </xsl:template>
    
</xsl:stylesheet>

