<?xml version="1.0"?> 

<!--

$Id: rss.xsl,v 1.1 2002/08/26 05:52:58 burton Exp $

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

-->

<!--
This XSL stylesheet support the following specifications:

     RSS 1.0 

     mod_dc 
          http://groups.yahoo.com/group/rss-dev/files/Modules/Standard/mod_dc.html

     mod_dcterms 
          http://groups.yahoo.com/group/rss-dev/files/Modules/Proposed/mod_dcterms.html

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:dcterms="http://purl.org/dc/terms/"
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:content="http://purl.org/rss/1.0/modules/content/"
                xmlns:rss-simple="http://my.netscape.com/rdf/simple/0.9/"
                xmlns:im="http://purl.org/rss/1.0/item-images/" 
                xmlns:annotate="http://purl.org/rss/1.0/modules/annotate/"
                xmlns:admin="http://webns.net/mvcb/"
                xmlns:image="http://purl.org/rss/1.0/modules/image/"
                xmlns:cc="http://web.resource.org/cc/"
                exclude-result-prefixes="rdf dc dcterms rss im content rss-simple im annotate admin image cc"
                version="1.0">
    
    <xsl:output indent="yes" 
                method="html"
                omit-xml-declaration="yes"/>

    <!--
         FIXME: 
         
         - We need to migrate the "Toggle Visible Content" button as the last
         entry in the metadata field.

     -->

    <!-- note: due to a bug in protozilla, we have to match at the root.  If we
    don't we will match on comments and if comments are before the html node we
    have problems -->
    
    <xsl:template match="/">

        <xsl:apply-templates select="/rss"/>

        <xsl:apply-templates select="/rdf:RDF"/>

    </xsl:template>

    <!-- RSS 0.9 and 1.0 support -->
    <xsl:template match="/rdf:RDF">

        <html>

            <head>

                <xsl:call-template name="css"/>
                <xsl:call-template name="javascript"/>

                <xsl:choose>

                    <xsl:when test="rss-simple:channel/rss-simple:title != ''">

                        <title><xsl:value-of select="rss-simple:channel/rss-simple:title"/></title>

                    </xsl:when>

                    <xsl:when test="rss:channel/rss:title != ''">

                        <title><xsl:value-of select="rss:channel/rss:title"/></title>

                    </xsl:when>

                </xsl:choose>

            </head>

            <body>
            
                <xsl:apply-templates select="rss-simple:channel"/>
                <xsl:apply-templates select="rss:channel"/>

                <xsl:apply-templates select="rss:textinput"/>
                <xsl:apply-templates select="rss-simple:textinput"/>

                <xsl:apply-templates select="rss-simple:item"/>
                <xsl:apply-templates select="rss:item"/>

            </body>

        </html>

    </xsl:template>

    <!-- RSS 0.91 support -->
    <xsl:template match="/rss">

        <html>

            <head>

                <xsl:call-template name="css"/>
                <xsl:call-template name="javascript"/>

                <title><xsl:value-of select="channel/title"/></title>

            </head>

            <body>
            
                <xsl:apply-templates select="channel"/>

            </body>

        </html>

    </xsl:template>

    <xsl:template match="rss-simple:textinput">

        <xsl:call-template name="textinput">

            <xsl:with-param name="title" select="rss-simple:title"/>
            <xsl:with-param name="link" select="rss-simple:link"/>
            <xsl:with-param name="name" select="rss-simple:name"/>
            <xsl:with-param name="description" select="rss-simple:description"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="rss:textinput">

        <xsl:call-template name="textinput">

            <xsl:with-param name="title" select="rss:title"/>
            <xsl:with-param name="link" select="rss:link"/>
            <xsl:with-param name="name" select="rss:name"/>
            <xsl:with-param name="description" select="rss:description"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="rss-simple:channel">

        <xsl:call-template name="channel">

            <xsl:with-param name="title" select="rss-simple:title"/>
            <xsl:with-param name="link" select="rss-simple:link"/>
            <xsl:with-param name="description" select="rss-simple:description"/>
            <xsl:with-param name="image-link" select="../rss-simple:image/rss-simple:link"/>
            <xsl:with-param name="image-url" select="../rss-simple:image/rss-simple:url"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="rss:channel">

        <xsl:call-template name="channel">

            <xsl:with-param name="title" select="rss:title"/>
            <xsl:with-param name="link" select="rss:link"/>
            <xsl:with-param name="description" select="rss:description"/>
            <xsl:with-param name="image-link" select="../rss:image/rss:link"/>
            <xsl:with-param name="image-url" select="../rss:image/rss:url"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="channel">

        <xsl:call-template name="channel">

            <xsl:with-param name="title" select="title"/>
            <xsl:with-param name="link" select="link"/>
            <xsl:with-param name="description" select="description"/>
            <xsl:with-param name="image-link" select="image/link"/>
            <xsl:with-param name="image-url" select="image/url"/>

        </xsl:call-template>

        <xsl:apply-templates select="item"/>

    </xsl:template>

    <xsl:template match="item">

        <xsl:call-template name="item">

            <xsl:with-param name="title" select="title"/>
            <xsl:with-param name="link" select="link"/>
            <xsl:with-param name="description" select="description"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="rss-simple:item">

        <xsl:call-template name="item">

            <xsl:with-param name="title" select="rss-simple:title"/>
            <xsl:with-param name="link" select="rss-simple:link"/>
            <xsl:with-param name="description" select="rss-simple:description"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="rss:item">

        <xsl:call-template name="item">

            <xsl:with-param name="title" select="rss:title"/>
            <xsl:with-param name="link" select="rss:link"/>
            <xsl:with-param name="description" select="rss:description"/>

        </xsl:call-template>

    </xsl:template>

    <xsl:template match="rdf:value|content:encoded">
        
        <div style="border-color: navy; border-style: dashed; border-width: thin; padding: 5;" >

            <div style="visibility: visible; display: block;">

                <xsl:choose>
                
                    <xsl:when test="@rdf:parseType = 'Literal'">

                        <!-- trigger XSLT copy -->

                        <xsl:apply-templates/>

                    </xsl:when>

                    <xsl:otherwise>

                        <xsl:value-of select="." disable-output-escaping="yes"/>

                    </xsl:otherwise>

                </xsl:choose>

            </div>

            <p style="font-size: smaller; font-weight: bold; text-align: right; cursor: pointer; text-decoration: underline;" onClick="ToggleVisible( this )">
                Toggle Visible Content
            </p>

        </div>

        <br/>

    </xsl:template>

    <xsl:template match="annotate:reference">

        <a href="{@rdf:resource}" class="metainfo-entry">Annotate</a>

    </xsl:template>

    <!-- get extracted content for items -->
    <xsl:template name="extracted-content">

        <xsl:param name="link"/>

        <xsl:variable name="content-servlet">

            <xsl:value-of select="concat( 'rss:http://localhost:8050/reptile/servlet/content/http/', substring-after( $link, 'http://' ) )"/>

        </xsl:variable>

        <a href="{$content-servlet}" class="metainfo-entry">Content</a>

    </xsl:template>

    <xsl:template match="cc:license">

        <span class="metainfo-topic">license permits:</span>

        <!-- FIXME: make sure we pay attention to resource -->

        <span class="metainfo-entry">

            <xsl:apply-templates select="/rdf:RDF/cc:License/cc:permits"/>

        </span>

        <span class="metainfo-topic">license requires:</span>

        <!-- FIXME: make sure we pay attention to resource -->

        <span class="metainfo-entry">

            <xsl:apply-templates select="/rdf:RDF/cc:License/cc:requires"/>

        </span>

    </xsl:template>

    <xsl:template match="/rdf:RDF/cc:License/cc:permits">

        <!-- FIXME: I really should be using substrings for this but I wanted
        lowercase -->

        <xsl:choose>

            <xsl:when test="@rdf:resource = 'http://web.resource.org/cc/Reproduction'">
                
                reproduction

            </xsl:when>

            <xsl:when test="@rdf:resource = 'http://web.resource.org/cc/Distribution'">
                
                distribution

            </xsl:when>

        </xsl:choose>

    </xsl:template>

    <xsl:template match="/rdf:RDF/cc:License/cc:requires">

        <!-- FIXME: I really should be using substrings for this but I wanted
        lowercase -->

        <xsl:choose>

            <xsl:when test="@rdf:resource = 'http://web.resource.org/cc/Notice'">
                
                notice

            </xsl:when>

            <xsl:when test="@rdf:resource = 'http://web.resource.org/cc/Attribution'">
                
                attribution

            </xsl:when>

        </xsl:choose>

    </xsl:template>

    <xsl:template match="admin:generatorAgent">

            <span class="metainfo-topic">
                generator:
            </span>
            
            <span class="metainfo-entry">
                <xsl:value-of select="@rdf:resource"/>
            </span>

    </xsl:template>

    <xsl:template match="admin:errorReportsTo">

            <span class="metainfo-topic">
                errors:
            </span>
            
            <span class="metainfo-entry">
                <a href="{@rdf:resource}"><xsl:value-of select="@rdf:resource"/></a>
            </span>

    </xsl:template>

    <xsl:template match="image:item">

        <img align="right" 
             src="{@rdf:about}"
             alt="{dc:title}"
             width="{image:width}"
             height="{image:height}"/>

    </xsl:template>

    <!-- =================================================================== -->
    <!--                      METAINFO TEMPLATES                             -->
    <!-- =================================================================== -->

    <xsl:template match="dc:*|dcterms:*|language|rss:language|lastBuildDate|rss:lastBuildDate|category|managingEditor|webmaster|rss:webMaster|copyright|pubDate|rss:pubDate">

        <xsl:choose>

            <xsl:when test="name(.) = 'dcterms:isPartOf'">

                <span class="metainfo-topic">
                    part of:
                </span>

                <span class="metainfo-entry">
                    <a href="{.}"><xsl:value-of select="."/></a>
                </span>

            </xsl:when>

            <xsl:when test=". != ''">

                <span class="metainfo-topic">
                    <xsl:value-of select="local-name(.)"/>: 
                </span>
                
                <span class="metainfo-entry">
                    <xsl:value-of select="."/>
                </span>
                
            </xsl:when>

        </xsl:choose>

    </xsl:template>

    <!--
         Handle all dublin core metainfo...
     -->
    <xsl:template name="metainfo">
        
        <xsl:apply-templates select="dc:subject"/>
        <xsl:apply-templates select="dc:date"/>
        <xsl:apply-templates select="dcterms:created"/>
        <xsl:apply-templates select="dcterms:valid"/>
        <xsl:apply-templates select="dcterms:available"/>
        <xsl:apply-templates select="dcterms:issued"/>
        <xsl:apply-templates select="dcterms:modified"/>
        <xsl:apply-templates select="dc:creator"/>
        <xsl:apply-templates select="dc:publisher"/>
        <xsl:apply-templates select="dc:contributor"/>
        <xsl:apply-templates select="dc:type"/>
        <xsl:apply-templates select="dc:language"/>
        <xsl:apply-templates select="dc:coverage"/>
        <xsl:apply-templates select="dcterms:spatial"/>
        <xsl:apply-templates select="dcterms:temporal"/>
        <xsl:apply-templates select="dc:rights"/>
        <xsl:apply-templates select="dc:format"/>
        <xsl:apply-templates select="dcterms:extent"/>
        <xsl:apply-templates select="dcterms:medium"/>
        <xsl:apply-templates select="dc:identifier"/>
        <xsl:apply-templates select="dc:relation"/>
        <xsl:apply-templates select="dc:audience"/>
        <xsl:apply-templates select="dcterms:dateAccepted"/>
        <xsl:apply-templates select="dcterms:dateSubmitted"/>
        <xsl:apply-templates select="dcterms:dateCopyrighted"/>

        <!-- RSS 0.91 support -->
        <xsl:apply-templates select="language"/>
        <xsl:apply-templates select="rss:language"/>
        <xsl:apply-templates select="lastBuildDate"/>
        <xsl:apply-templates select="rss:lastBuildDate"/>
        <xsl:apply-templates select="category"/>
        <xsl:apply-templates select="managingEditor"/>
        <xsl:apply-templates select="webmaster"/>
        <xsl:apply-templates select="rss:webMaster"/>
        <xsl:apply-templates select="copyright"/>
        <xsl:apply-templates select="pubDate"/>
        <xsl:apply-templates select="rss:pubDate"/>

        <xsl:apply-templates select="dcterms:isPartOf"/>

    </xsl:template>

    <!-- =================================================================== -->
    <!--                        NAMED TEMPLATES                              -->
    <!-- =================================================================== -->

    <!-- 

         Create an item entry with title, link and description.  We disable
         output escaping so that users can syndicate HTML content.  Although
         this is not really XML compliant is seems like common practice and
         since it doesn't break anything we are going to enable this.

         -->
    <xsl:template name="item">

        <xsl:param name="title"/>
        <xsl:param name="link"/>
        <xsl:param name="description" select="''"/>

        <xsl:param name="disable-content-link" select="'false'"/>

        <xsl:apply-templates select="image:item"/>

        <xsl:if test="im:image != ''">
            
            <img src="{im:image}" align="right"/>
            
        </xsl:if>

        <!-- titles should be bold so as to differentiate them from other types
             of links -->

        <xsl:choose>

            <!--
                 RSS 0.92 titles are optional.  We test this here.  For the other
                 RSS formats this will work just fine.  -->

            <xsl:when test="string-length( $title ) != 0 and string-length( $link ) != 0">

                <!-- figure out what to do with favicons -->

                <xsl:choose>
                
                    <xsl:when test="../rss:channel/image:favicon">

                        <table>
                            <td>
                                <img src="{../rss:channel/image:favicon/@rdf:about}" width="16" height="16"/>
                            </td>

                            <td>

                                <a href="{$link}" class="title" style="margin-right: 5;">
                                    <xsl:value-of select="$title" disable-output-escaping="yes"/>
                                </a>
                            </td>

                        </table>

                    </xsl:when>

                    <xsl:otherwise>

                        <li style="margin-bottom: 8; margin-top: 8;">
                            <a href="{$link}" class="title" style="margin-right: 5;">
                                <xsl:value-of select="$title" disable-output-escaping="yes"/>
                            </a>
                        </li>

                    </xsl:otherwise>

                </xsl:choose>

                <div style="margin-left: 16;">

                    <xsl:value-of select="$description" disable-output-escaping="yes"/>

                    <!-- I have noticed that a few sites syndicate no RSS description
                         element but with a dc:description element.  A solid example
                         would be the XMLHack feed at http://xmlhack.com/rss10.php
                         -->
                    <xsl:if test="string-length( $description ) = 0 and ./dc:description != ''">

                        <xsl:value-of select="dc:description" disable-output-escaping="yes"/>

                    </xsl:if>

                </div>

            </xsl:when>

            <xsl:otherwise>

                <!-- RSS 0.92 description -->

                <xsl:value-of select="$description" disable-output-escaping="yes"/>

                <!-- FIXME: figure out what to do here.  We can't use a hr
                because it looks ugly.  We can't use an li because if they
                encode a 'p' there is a paragraph break ... ug. -->

            </xsl:otherwise>

        </xsl:choose>

                <!-- RSS 0.92 source links -->
        <!-- FIXME: put this back in -->
<!--                 <xsl:if test="./source != ''"> -->

<!--                     <br/> -->
<!--                     <br/> -->
<!--                     <span class="metainfo-cat">Source:</span>  -->
                    
<!--                     <a href="{./source/@url}"  -->
<!--                        class="metainfo-value" style="margin-left: 5;"> -->
<!--                         <xsl:value-of select="./source"/> -->

<!--                     </a> -->

<!--                 </xsl:if> -->

        <!-- It is necessary to 'clear' if there is a description because
             sometimes people syndicate images which could block the following
             metainfo -->
        <div style="margin-left: 15; margin-top: 8; margin-bottom: 8; clear: right;">

            <xsl:apply-templates select="annotate:reference"/>

            <xsl:if test="$disable-content-link = 'false'">

                <xsl:call-template name="extracted-content">
                    
                    <xsl:with-param name="link" select="$link"/>
                    
                </xsl:call-template>

            </xsl:if>

            <xsl:call-template name="metainfo"/>

            <xsl:apply-templates select="cc:license"/>

        </div>

        <xsl:if test="im:image">

            <!-- FIXME: migrate this to using the clear CSS property ? -->

            <br clear="all"/>

        </xsl:if>

        <xsl:if test="string-length( $title ) = 0 and string-length( $link ) = 0">

            <!-- Break on RSS 0.92 when we have empty titles -->
<!--             <center> -->
<!--                 <hr style="border:1px gray solid; height: 0px; margin: 0; padding: 0; width: 90%;"/> -->
<!--             </center> -->

        </xsl:if>

        <!-- now support mod_content -->

        <xsl:apply-templates select="content:items/rdf:Bag/rdf:li/content:item/rdf:value"/>
        <xsl:apply-templates select="content:encoded"/>

    </xsl:template>

    <xsl:template name="channel">

        <xsl:param name="title"/>
        <xsl:param name="link"/>
        <xsl:param name="description"/>
        <xsl:param name="image-link"/>
        <xsl:param name="image-url"/>

        <p>

            <table width="100%">

                <td valign="middle">

                    <h2>
                        
                        <a href="{link}" style="color: #0033CC">
                            
                            <xsl:value-of select="$title"/>

                        </a>

                    </h2>

                </td>
                
                <td valign="middle">

                    <xsl:if test="$image-link != '' and $image-url != ''">

                        <a href="{$image-link}">
                            
                            <img src="{$image-url}" align="right" border="0"/>
                            
                        </a>

                    </xsl:if>

                </td>                

            </table>

        </p>

        <p>

            <xsl:value-of select="$description" disable-output-escaping="yes"/>

        </p>

        <p>
            <xsl:apply-templates select="admin:generatorAgent"/>
            <xsl:apply-templates select="admin:errorReportsTo"/>

            <xsl:call-template name="metainfo"/>
        </p>

    </xsl:template>

    <xsl:template name="textinput">

        <xsl:param name="title"/>
        <xsl:param name="description"/>
        <xsl:param name="name"/>
        <xsl:param name="link"/>

        <center>

            <form action="{$link}">

                <span style="margin-right: 5;"><xsl:value-of select="$description"/></span>

                <input name="{$name}" type="text" style="margin-right: 5;"/>

                <input type="submit" value="{$title}"/>

            </form>

        </center>

    </xsl:template>

    <xsl:template name="css">

        <style>

            .metainfo-entry { font-size: smaller; color: gray; margin-right: 5; }
            .metainfo-topic { font-size: smaller; font-weight: bold; color: gray; margin-right: 2; }

            A:link { color: navy }
            A:visited { color: black }
            A:active { color: gray }
            a:hover { background: #ffa } 

            hr {

            border:1px #000000 solid;

            }

            body {

            font-family: "Times New Roman", Times, serif;
            font-style: normal;
            color: #000000;
            background-color: #FFFFFF;

            }

            h1 {
            font-family: Arial, Helvetica, sans-serif;
            color: #0033CC
            }

            h2 {
            font-family: Arial, Helvetica, sans-serif;
            color: #0033CC
            }

            h3 {
            font-family: Arial, Helvetica, sans-serif;
            color: #0033CC
            }

            h4 {
            font-family: Arial, Helvetica, sans-serif;
            color: #0033CC
            }

            h5 {
            font-family: Arial, Helvetica, sans-serif;
            color: #0033CC
            }

            h6 {
            font-family: Arial, Helvetica, sans-serif;
            color: #0033CC
            }

            b {
            font-weight: bold;
            }

            td {
            padding: 0;
            margin: 0;
            }

            .bookmark { 

            margin: 5;

            }

            .timestamp 
            {
            font-family: Verdana, Arial, Helvetica, sans-serif; 
            font-size: smaller;
            color: gray;
            line-height: normal;
            font-size: smaller;
            margin-right: 5;
            }

            //metainfo category
            .metainfo-cat
            {
            font-size: smaller;
            font-weight: bold;
            color: black;
            }

            //metainfo value
            .metainfo-cat
            {
            
            font-size: smaller;
            color: gray;
            }

            .title
            {
            font-weight: bold;
            }

            pre {
            
            font-size: small;

            }

            code {

            font-family: "Courier New", monospace; 
            background-color: #efeff5;
            white-space: pre;

            }

        </style>

    </xsl:template>

    <xsl:template name="javascript">

        <script language="javascript">

            function ToggleVisible(element) {

                x = element.parentNode.getElementsByTagName( 'div' )[0]

                if ( x.style.visibility == 'collapse' ) { 

                    x.style.visibility='visible';
                    x.style.display='block';

                } else {

                    x.style.visibility='collapse';
                    x.style.display='none';            

                }

            }

        </script>

    </xsl:template>

    <xsl:template match="@*|node()">

        <xsl:copy-of select="."/>

    </xsl:template>

</xsl:stylesheet>

