<?xml version="1.0"?> 

<!--

$Id: controller.xsl,v 1.11 2001/12/13 05:32:16 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Handles building the structure for this reputation-management session.

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rm="http://schemas.openprivacy.org/reptile/reputation-management"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:reputation="xalan://org.openprivacy.reptile.extensions.ReputationExtension"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                extension-element-prefixes="reputation"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="identifier" select="''"/>

    <xsl:template match="/rm:reputation-management">

        <control:content>
    
            <control:location><xsl:value-of select="$identifier"/></control:location>
    
            <dc:title>Reputation for <xsl:value-of select="$identifier"/></dc:title>
    
            <control:body>
    
                <p>
                This page lets you view and update Reputation for a specific URL.  
                </p>
    
    
                <table>
    
                <tr>
                
                <td>
                <b>Reputation for: </b>
                </td>
                
                <td>
                <xsl:value-of select="$identifier"/>
                </td>
    
                </tr>
    
                <tr>
                
                <td>
                <b>Value:</b>
                </td>
    
                <td>
                <xsl:value-of select="reputation:getReputation( string( $identifier ) )"/>
                </td>
    
                </tr>
    
                </table>
    
                <form method="post">
    
                <table>
    
                <td>
                Set reputation: 
                </td>
        
                <td>
    
                <select name="payload-option">
        
                    <option value="4">Excellent</option>
                    <option value="3">Good</option>
                    <option value="2" selected="true">Average</option>
                    <option value="1">Bad</option>
                    <option value="0">Terrible</option>
        
                </select>
    
                </td>    
    
                <td>
    
                <input name="identifier" type="hidden">
        
                    <xsl:attribute name="value">
                    
                        <xsl:value-of select="$identifier"/>
        
                    </xsl:attribute>
        
                </input>        
    
                <input type="hidden" name="reptile.action" value="PutReputation"/>
    
        
                <input type="submit"/>
    
                </td>
                
                </table>
        
                </form>
            
            </control:body>
    
        </control:content>

    </xsl:template>

</xsl:stylesheet>





