<?xml version="1.0"?> 

<!--

$Id: login.xsl,v 1.17 2001/12/20 23:16:12 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:login="http://schemas.openprivacy.org/reptile/login"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:log="xalan://org.openprivacy.reptile.extensions.LogExtension"
                extension-element-prefixes="log"
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>
    
    <xsl:template match="/login:login">

        <control:content>

            <dc:title>Please login</dc:title>                

            <control:body>

                <p>

                <img src="/reptile/images/login.png" align="right" hspace="10" vspace="10"/>

                Before doing anything you must login to Reptile.

                </p>

                <p>
                Note: Right now it doesn't matter what you enter here.  Sierra isn't
                smart enough to know anything about Crypto and it is just using the
                username you are entering as a key for skeleton Nym generation.  You
                can also enter any passphrase you want as this isn't used. 
                </p>            

                <p>
                You will need to use an advanced web browser.  Netscape 4.x
                will not work.  If you are having problems try using
b                Mozilla, Konqueror or Internet Explorer.
                </p>

                <p>
                When Reptile first starts up things may be a little slow.
                It takes Reptile a while to learn from your behavior and
                increase it's speed.  Within 50 or 60 seconds things should
                be running smoothly.
                </p>

                <p>
                <b>Privacy notice:</b> None of the information you supply on
                the login page, including username and passphrase, is
                available on the Internet.  This information is only used
                locally within Reptile for identification purposes.
                </p>

                <div align="center">
            
                <form action="{$reptile.home.location}" method="post">
                
                <table>        
                
                <tr>

                <td>
                Username: 
                </td>
                
                <td>
                <input type="text" name="username"/>
                </td>

                </tr>        

                <tr>
                
                <td>
                Passphrase: 
                </td>

                <td>
                <input type="password" name="passphrase"/>
                </td>
                
                </tr>
                        
                <tr>

                <td colspan="2" align="center">
                <input type="submit" name="submit" value="Login"/>                
                </td>

                </tr>
                </table>

                <input type="hidden" name="reptile.action" value="Login"/>

                </form>

                </div>

            </control:body>

        </control:content>

    </xsl:template>

</xsl:stylesheet>

