use reptile;

# -----------------------------------------------------------------------
# FEED
# -----------------------------------------------------------------------
drop table if exists FEED;

CREATE TABLE FEED
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    LOCATION MEDIUMTEXT NOT NULL,
    CONTENT_TYPE MEDIUMTEXT NOT NULL,
    DATE_FOUND BIGINT NOT NULL,
    LAST_UPDATED BIGINT NOT NULL,
    COPYRIGHT MEDIUMTEXT,
    PRIMARY KEY(ID),
    INDEX INDX_FEED_LOCATION (LOCATION(128))
        ,INDEX INDX_FEED_ID (ID)
   
);

# -----------------------------------------------------------------------
# CHANNEL
# -----------------------------------------------------------------------
drop table if exists CHANNEL;

CREATE TABLE CHANNEL
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    LOCATION MEDIUMTEXT NOT NULL,
    SITE MEDIUMTEXT,
    CONTENT_TYPE MEDIUMTEXT NOT NULL,
    TITLE MEDIUMTEXT NOT NULL,
    DESCRIPTION MEDIUMTEXT,
    IMAGE_FK INTEGER,
    SOURCE MEDIUMTEXT,
    DATE_FOUND BIGINT NOT NULL,
    LAST_UPDATED BIGINT NOT NULL,
    COPYRIGHT MEDIUMTEXT,
    CATEGORY_FK INTEGER,
    SUBSCRIBED INTEGER default 0 NOT NULL,
    INDEXED INTEGER default 0,
    INITIALIZED INTEGER default 0 NOT NULL,
    PUBLISHER MEDIUMTEXT,
    CREATOR MEDIUMTEXT,
    PRIMARY KEY(ID),
    FOREIGN KEY (IMAGE_FK) REFERENCES IMAGE (ID),
    FOREIGN KEY (CATEGORY_FK) REFERENCES CATEGORY (ID),
    UNIQUE (LOCATION(128)),
    INDEX INDX_CHANNEL_LOCATION (LOCATION(128))
        ,INDEX INDX_CHANNEL_ID (ID)
   
);

# -----------------------------------------------------------------------
# IMAGE
# -----------------------------------------------------------------------
drop table if exists IMAGE;

CREATE TABLE IMAGE
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    CHANNEL MEDIUMTEXT NOT NULL,
    LOCATION MEDIUMTEXT NOT NULL,
    WIDTH INTEGER,
    HEIGHT INTEGER,
    TITLE MEDIUMTEXT,
    DESCRIPTION MEDIUMTEXT,
    PRIMARY KEY(ID),
    UNIQUE (CHANNEL(128)),
    INDEX INDX_IMAGE_ID (ID)
        ,INDEX INDX_IMAGE_CHANNEL (CHANNEL(128))
   
);

# -----------------------------------------------------------------------
# ARTICLE
# -----------------------------------------------------------------------
drop table if exists ARTICLE;

CREATE TABLE ARTICLE
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    LOCATION MEDIUMTEXT NOT NULL,
    CHANNEL MEDIUMTEXT,
    TITLE MEDIUMTEXT,
    DESCRIPTION MEDIUMTEXT,
    COPYRIGHT MEDIUMTEXT,
    DC_CREATOR MEDIUMTEXT,
    DC_SUBJECT MEDIUMTEXT,
    DATE_FOUND BIGINT NOT NULL,
    LAST_UPDATED BIGINT NOT NULL,
    MARKED_READ INTEGER default 0 NOT NULL,
    PRIMARY KEY(ID),
    UNIQUE (LOCATION(128)),
    INDEX INDX_ARTICLE_LOCATION (LOCATION(128))
        ,INDEX INDX_ARTICLE_CHANNEL (CHANNEL(128))
        ,INDEX INDX_ARTICLE_CHANNEL_MARKED_READ (CHANNEL(128), MARKED_READ)
        ,INDEX INDX_ARTICLE_ID (ID)
   
);

# -----------------------------------------------------------------------
# FAVICON
# -----------------------------------------------------------------------
drop table if exists FAVICON;

CREATE TABLE FAVICON
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    SITE MEDIUMTEXT NOT NULL,
    LOCATION MEDIUMTEXT,
    STATUS INTEGER NOT NULL,
    PRIMARY KEY(ID),
    UNIQUE (LOCATION(128)),
    UNIQUE (SITE(128)),
    INDEX INDX_FAVICON_LOCATION (LOCATION(128))
        ,INDEX INDX_FAVICON_SITE (SITE(128))
   
);

# -----------------------------------------------------------------------
# MONITOR
# -----------------------------------------------------------------------
drop table if exists MONITOR;

CREATE TABLE MONITOR
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    CHANNEL_FK INTEGER NOT NULL,
    PRIMARY KEY(ID,CHANNEL_FK),
    INDEX(CHANNEL_FK),
    FOREIGN KEY (CHANNEL_FK) REFERENCES CHANNEL (ID)
);

# -----------------------------------------------------------------------
# CATEGORY
# -----------------------------------------------------------------------
drop table if exists CATEGORY;

CREATE TABLE CATEGORY
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    NAME MEDIUMTEXT NOT NULL,
    PRIMARY KEY(ID),
    UNIQUE (NAME(128)),
    INDEX INDX_CATEGORY_ID (ID)
   
);

# -----------------------------------------------------------------------
# WEBLOG
# -----------------------------------------------------------------------
drop table if exists WEBLOG;

CREATE TABLE WEBLOG
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    LOCATION MEDIUMTEXT NOT NULL,
    TITLE MEDIUMTEXT,
    DESCRIPTION MEDIUMTEXT,
    COMMENTS MEDIUMTEXT,
    DC_SUBJECT MEDIUMTEXT,
    DATE_FOUND BIGINT NOT NULL,
    LAST_UPDATED BIGINT NOT NULL,
    PRIMARY KEY(ID),
    INDEX INDX_CHANNEL_LOCATION (LOCATION(128))
        ,INDEX INDX_WEBLOG_ID (ID)
   
);

# -----------------------------------------------------------------------
# TEXTINPUT
# -----------------------------------------------------------------------
drop table if exists TEXTINPUT;

CREATE TABLE TEXTINPUT
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    SITE MEDIUMTEXT NOT NULL,
    CHANNEL MEDIUMTEXT NOT NULL,
    LINK MEDIUMTEXT NOT NULL,
    TITLE MEDIUMTEXT NOT NULL,
    DESCRIPTION MEDIUMTEXT,
    NAME MEDIUMTEXT NOT NULL,
    PRIMARY KEY(ID),
    INDEX INDX_TEXTINPUT_ID (ID)
   
);

# -----------------------------------------------------------------------
# SETTING
# -----------------------------------------------------------------------
drop table if exists SETTING;

CREATE TABLE SETTING
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    NAME MEDIUMTEXT NOT NULL,
    VALUE MEDIUMTEXT NOT NULL,
    PRIMARY KEY(ID),
    INDEX INDX_CONFIG_ID (ID)
   
);

# -----------------------------------------------------------------------
# TASK_LOG
# -----------------------------------------------------------------------
drop table if exists TASK_LOG;

CREATE TABLE TASK_LOG
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    IDENTIFIER MEDIUMTEXT NOT NULL,
    STATUS MEDIUMTEXT NOT NULL,
    TASK MEDIUMTEXT NOT NULL,
    DATE BIGINT NOT NULL,
    MESSAGE MEDIUMTEXT,
    EXCEPTION_CLASSNAME MEDIUMTEXT,
    EXCEPTION_STACKTRACE MEDIUMTEXT,
    PRIMARY KEY(ID),
    INDEX INDX_UPDATE_LOG_IDENTIFIER (IDENTIFIER(128))
        ,INDEX INDX_UPDATE_LOG_ID (ID)
   
);

# -----------------------------------------------------------------------
# REMOTE_SEARCH_PROVIDER
# -----------------------------------------------------------------------
drop table if exists REMOTE_SEARCH_PROVIDER;

CREATE TABLE REMOTE_SEARCH_PROVIDER
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    NAME MEDIUMTEXT NOT NULL,
    LOCATION MEDIUMTEXT NOT NULL,
    SERVICE_IDENTIFIER MEDIUMTEXT NOT NULL,
    TRANSPORT MEDIUMTEXT NOT NULL,
    SUPERNODE INTEGER default 0 NOT NULL,
    INTERFACE_IDENTIFIER MEDIUMTEXT NOT NULL,
    PRIMARY KEY(ID),
    INDEX INDX_REMOTE_SEARCH_PROVIDER_LOCATION (LOCATION(128))
        ,INDEX INDX_REMOTE_SEARCH_PROVIDER_ID (ID)
   
);

# -----------------------------------------------------------------------
# PEER_ADVERTISEMENT
# -----------------------------------------------------------------------
drop table if exists PEER_ADVERTISEMENT;

CREATE TABLE PEER_ADVERTISEMENT
(
    ID INTEGER NOT NULL AUTO_INCREMENT,
    DATE_FOUND BIGINT NOT NULL,
    TYPE MEDIUMTEXT NOT NULL,
    NAME MEDIUMTEXT NOT NULL,
    ADVERTISEMENT_ID MEDIUMTEXT NOT NULL,
    PEER_ID MEDIUMTEXT NOT NULL,
    TITLE MEDIUMTEXT NOT NULL,
    DESCRIPTION MEDIUMTEXT NOT NULL,
    IMAGE MEDIUMTEXT NOT NULL,
    LOCAL_EXPIRATION_TIME BIGINT NOT NULL,
    PRIMARY KEY(ID),
    INDEX INDX_PEER_ADVERTISEMENT_ID (ID)
   
);
