
-----------------------------------------------------------------------------
-- FEED
-----------------------------------------------------------------------------
CREATE CACHED TABLE FEED
(
    ID integer IDENTITY,
    LOCATION VARCHAR,
    CONTENT_TYPE VARCHAR,
    DATE_FOUND BIGINT,
    LAST_UPDATED BIGINT,
    COPYRIGHT VARCHAR,
    PRIMARY KEY(ID)
);

CREATE  INDEX INDX_FEED_LOCATION ON FEED (LOCATION);
CREATE  INDEX INDX_FEED_ID ON FEED (ID);
-----------------------------------------------------------------------------
-- CHANNEL
-----------------------------------------------------------------------------
CREATE CACHED TABLE CHANNEL
(
    ID integer IDENTITY,
    LOCATION VARCHAR,
    SITE VARCHAR,
    CONTENT_TYPE VARCHAR,
    TITLE VARCHAR,
    DESCRIPTION VARCHAR,
    IMAGE_FK integer,
    SOURCE VARCHAR,
    DATE_FOUND BIGINT,
    LAST_UPDATED BIGINT,
    COPYRIGHT VARCHAR,
    CATEGORY_FK integer,
    SUBSCRIBED integer,
    INDEXED integer,
    INITIALIZED integer,
    PUBLISHER VARCHAR,
    CREATOR VARCHAR,
    PRIMARY KEY(ID),
    UNIQUE (LOCATION)
);

CREATE  INDEX INDX_CHANNEL_LOCATION ON CHANNEL (LOCATION);
CREATE  INDEX INDX_CHANNEL_ID ON CHANNEL (ID);
-----------------------------------------------------------------------------
-- IMAGE
-----------------------------------------------------------------------------
CREATE CACHED TABLE IMAGE
(
    ID integer IDENTITY,
    CHANNEL VARCHAR,
    LOCATION VARCHAR,
    WIDTH integer,
    HEIGHT integer,
    TITLE VARCHAR,
    DESCRIPTION VARCHAR,
    PRIMARY KEY(ID),
    UNIQUE (CHANNEL)
);

CREATE  INDEX INDX_IMAGE_ID ON IMAGE (ID);
CREATE  INDEX INDX_IMAGE_CHANNEL ON IMAGE (CHANNEL);
-----------------------------------------------------------------------------
-- ARTICLE
-----------------------------------------------------------------------------
CREATE CACHED TABLE ARTICLE
(
    ID integer IDENTITY,
    LOCATION VARCHAR,
    CHANNEL VARCHAR,
    TITLE VARCHAR,
    DESCRIPTION VARCHAR,
    COPYRIGHT VARCHAR,
    DC_CREATOR VARCHAR,
    DC_SUBJECT VARCHAR,
    DATE_FOUND BIGINT,
    LAST_UPDATED BIGINT,
    MARKED_READ integer,
    PRIMARY KEY(ID),
    UNIQUE (LOCATION)
);

CREATE  INDEX INDX_ARTICLE_LOCATION ON ARTICLE (LOCATION);
CREATE  INDEX INDX_ARTICLE_CHANNEL ON ARTICLE (CHANNEL);
CREATE  INDEX INDX_ARTICLE_CHANNEL_MARKED_READ ON ARTICLE (CHANNEL, MARKED_READ);
CREATE  INDEX INDX_ARTICLE_ID ON ARTICLE (ID);
-----------------------------------------------------------------------------
-- FAVICON
-----------------------------------------------------------------------------
CREATE CACHED TABLE FAVICON
(
    ID integer IDENTITY,
    SITE VARCHAR,
    LOCATION VARCHAR,
    STATUS integer,
    PRIMARY KEY(ID),
    UNIQUE (LOCATION),
    UNIQUE (SITE)
);

CREATE  INDEX INDX_FAVICON_LOCATION ON FAVICON (LOCATION);
CREATE  INDEX INDX_FAVICON_SITE ON FAVICON (SITE);
-----------------------------------------------------------------------------
-- MONITOR
-----------------------------------------------------------------------------
CREATE CACHED TABLE MONITOR
(
    ID integer IDENTITY,
    CHANNEL_FK integer,
    PRIMARY KEY(ID,CHANNEL_FK)
);


-----------------------------------------------------------------------------
-- CATEGORY
-----------------------------------------------------------------------------
CREATE CACHED TABLE CATEGORY
(
    ID integer IDENTITY,
    NAME VARCHAR,
    PRIMARY KEY(ID),
    UNIQUE (NAME)
);

CREATE  INDEX INDX_CATEGORY_ID ON CATEGORY (ID);
-----------------------------------------------------------------------------
-- WEBLOG
-----------------------------------------------------------------------------
CREATE CACHED TABLE WEBLOG
(
    ID integer IDENTITY,
    LOCATION VARCHAR,
    TITLE VARCHAR,
    DESCRIPTION VARCHAR,
    COMMENTS VARCHAR,
    DC_SUBJECT VARCHAR,
    DATE_FOUND BIGINT,
    LAST_UPDATED BIGINT,
    PRIMARY KEY(ID)
);

CREATE  INDEX INDX_CHANNEL_LOCATION ON WEBLOG (LOCATION);
CREATE  INDEX INDX_WEBLOG_ID ON WEBLOG (ID);
-----------------------------------------------------------------------------
-- TEXTINPUT
-----------------------------------------------------------------------------
CREATE CACHED TABLE TEXTINPUT
(
    ID integer IDENTITY,
    SITE VARCHAR,
    CHANNEL VARCHAR,
    LINK VARCHAR,
    TITLE VARCHAR,
    DESCRIPTION VARCHAR,
    NAME VARCHAR,
    PRIMARY KEY(ID)
);

CREATE  INDEX INDX_TEXTINPUT_ID ON TEXTINPUT (ID);
-----------------------------------------------------------------------------
-- SETTING
-----------------------------------------------------------------------------
CREATE CACHED TABLE SETTING
(
    ID integer IDENTITY,
    NAME VARCHAR,
    VALUE VARCHAR,
    PRIMARY KEY(ID)
);

CREATE  INDEX INDX_CONFIG_ID ON SETTING (ID);
-----------------------------------------------------------------------------
-- TASK_LOG
-----------------------------------------------------------------------------
CREATE CACHED TABLE TASK_LOG
(
    ID integer IDENTITY,
    IDENTIFIER VARCHAR,
    STATUS VARCHAR,
    TASK VARCHAR,
    DATE BIGINT,
    MESSAGE VARCHAR,
    EXCEPTION_CLASSNAME VARCHAR,
    EXCEPTION_STACKTRACE VARCHAR,
    PRIMARY KEY(ID)
);

CREATE  INDEX INDX_UPDATE_LOG_IDENTIFIER ON TASK_LOG (IDENTIFIER);
CREATE  INDEX INDX_UPDATE_LOG_ID ON TASK_LOG (ID);
-----------------------------------------------------------------------------
-- REMOTE_SEARCH_PROVIDER
-----------------------------------------------------------------------------
CREATE CACHED TABLE REMOTE_SEARCH_PROVIDER
(
    ID integer IDENTITY,
    NAME VARCHAR,
    LOCATION VARCHAR,
    SERVICE_IDENTIFIER VARCHAR,
    TRANSPORT VARCHAR,
    SUPERNODE integer,
    INTERFACE_IDENTIFIER VARCHAR,
    PRIMARY KEY(ID)
);

CREATE  INDEX INDX_REMOTE_SEARCH_PROVIDER_LOCATION ON REMOTE_SEARCH_PROVIDER (LOCATION);
CREATE  INDEX INDX_REMOTE_SEARCH_PROVIDER_ID ON REMOTE_SEARCH_PROVIDER (ID);
-----------------------------------------------------------------------------
-- PEER_ADVERTISEMENT
-----------------------------------------------------------------------------
CREATE CACHED TABLE PEER_ADVERTISEMENT
(
    ID integer IDENTITY,
    DATE_FOUND BIGINT,
    TYPE VARCHAR,
    NAME VARCHAR,
    ADVERTISEMENT_ID VARCHAR,
    PEER_ID VARCHAR,
    TITLE VARCHAR,
    DESCRIPTION VARCHAR,
    IMAGE VARCHAR,
    LOCAL_EXPIRATION_TIME BIGINT,
    PRIMARY KEY(ID)
);

CREATE  INDEX INDX_PEER_ADVERTISEMENT_ID ON PEER_ADVERTISEMENT (ID);