#!/bin/sh

###
#
# $Id: update-reptile-resources.sh,v 1.29 2002/02/08 01:05:52 burton Exp $
#
# Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the LICENSE which you should have obtaind with this package.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.
#
# Commentary:
# 
# ADD COMMENT
#
#  This is a quick script which will update the resources of a running Reptile
#  instance so that all new XSL, XML, etc is available without having to restart
#  Reptile.
#
#  You will need to update variables to reflect your system.
#
###

#Home of your tomcat install
TOMCAT_HOME="/projects/reptile/bin/distribution/reptile-current"

#Home of your reptile CVS checkout
REPTILE_HOME="/projects/reptile"

PANTHER_HOME="/projects/panther"

function update {
    
    source=$1
    dest=$2

    cp --verbose --force --update $source $dest

}

function update_recursive {

    source=$1
    dest=$2

    cp --verbose --force --update --recursive $source $dest

}

echo
echo "Updating content in $TOMCAT_HOME"
echo

update_recursive "$REPTILE_HOME/src/javascript/*" "$TOMCAT_HOME/webapps/reptile/javascript/"

update_recursive "$REPTILE_HOME/src/xsl/*" "$TOMCAT_HOME/webapps/reptile/xsl/"

update_recursive "$REPTILE_HOME/src/webcontent/*" "$TOMCAT_HOME/webapps/reptile/"
update "$REPTILE_HOME/src/xml/users/default/publish.xml" "$TOMCAT_HOME/webapps/reptile/xml/users/default"
update "$REPTILE_HOME/src/xml/users/default/tools.xml" "$TOMCAT_HOME/webapps/reptile/xml/users/default"

update "$REPTILE_HOME/src/xml/*" "$TOMCAT_HOME/webapps/reptile/xml/"

update_recursive "$REPTILE_HOME/src/xml/about/*" "$TOMCAT_HOME/webapps/reptile/xml/about"
update_recursive "$REPTILE_HOME/src/xml/content/*" "$TOMCAT_HOME/webapps/reptile/xml/content"
update_recursive "$REPTILE_HOME/src/xml/settings/*" "$TOMCAT_HOME/webapps/reptile/xml/settings"
update_recursive "$REPTILE_HOME/src/xml/search/*" "$TOMCAT_HOME/webapps/reptile/xml/search"
update_recursive "$REPTILE_HOME/src/xml/tests/*" "$TOMCAT_HOME/webapps/reptile/xml/tests"

update_recursive "$REPTILE_HOME/src/xml/misc/*" "$TOMCAT_HOME/webapps/reptile/xml/misc/"

update_recursive "$REPTILE_HOME/src/scripts/*" "$TOMCAT_HOME/"

update "$REPTILE_HOME/bin/reptile.jar" "$TOMCAT_HOME/webapps/reptile/WEB-INF/lib"

#update project specific libararies.
update "$REPTILE_HOME/src/config/* $TOMCAT_HOME/webapps/reptile/WEB-INF/etc"

update "$PANTHER_HOME/bin/panther.jar" "$TOMCAT_HOME/webapps/reptile/WEB-INF/lib"

#update "$REPTILE_HOME/src/xml/users/default/mychannel.rss" "$TOMCAT_HOME/webapps/reptile/xml/users/default"

update "$REPTILE_HOME/reptile.xml" "$TOMCAT_HOME"

update_recursive "$REPTILE_HOME/bin/classes/*" "$TOMCAT_HOME/webapps/reptile/WEB-INF/classes/"

update_recursive "$REPTILE_HOME/src/xml/license/*" "$TOMCAT_HOME/webapps/reptile/xml/license"
update_recursive "$REPTILE_HOME/src/xsl/license/*" "$TOMCAT_HOME/webapps/reptile/xsl/license"


 find $TOMCAT_HOME -name *.xsl -exec touch "{}" ";"