/*
 * ----
 *
 * $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * Represents a stack(FIFO) of stylesheets which will be processed on the order
 * they added by a StylesheetEngine
 *
 * <p>
 * For example if you have the following code:
 *
 * <code>
 *
 * addStylesheet( "one.xsl" )
 * addStylesheet( "two.xsl" )
 * addStylesheet( "three.xsl" )
 *
 * </code>
 *
 * A StylesheetEngine will process the files as one.xsl, two.xsl and then three.xsl
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
 */
public class StylesheetStack {

    private ArrayList stack = new ArrayList();

    public StylesheetStack() { }

    /**
     * @see #addStylesheet
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
     */
    public void addStylesheet( URI uri ) {

        if ( stack.contains( uri ) == false )
            this.stack.add( uri );
        
    }

    /**
     * Add a new stylesheet.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
     */
    public void addStylesheet( String uri ) {

        addStylesheet( new URI( uri ) );
        
    }

    /**
     * Get the vector used to represent this stack.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
     */
    protected List getStack() {

        return this.stack;
        
    }

    /**
     * Get an iterator for this StylesheetStack so that we can go over it...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
     */
    public Iterator getIterator() {

        return this.stack.iterator();

    }

    /**
     *
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
     */
    public int size() {

        return stack.size();
        
    }
    
    /**
     * @see Object#equals
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
     */
    public boolean equals( Object obj ) {

        if ( this.getClass() == obj.getClass() ) {

            StylesheetStack other = (StylesheetStack)obj;

            return getStack().equals( other.getStack() );

        }

        return false;            

    }
    
    /**
     * @see Object#hashCode
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: StylesheetStack.java,v 1.2 2002/02/21 22:41:24 burton Exp $
     */
    public int hashCode() {

        int hashCode = 0;
        
        Iterator i = stack.iterator();

        while ( i.hasNext() )
            hashCode += i.next().toString().hashCode();
        
        return hashCode;
        
    }
    
}
