/*
 * ---- 
 *
 * $Id: StylesheetEngineFactory.java,v 1.2 2001/12/12 09:41:21 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.cache.sequence.*;

/**
 * Given an XML document and a StylesheetStack this will use TRAX to transform
 * all the content.  
 *
 * @version $Id: StylesheetEngineFactory.java,v 1.2 2001/12/12 09:41:21 burton Exp $
 */
public class StylesheetEngineFactory {

    public static final String ORG_OPENPRIVACY_REPTILE_XSLT_STYLESHEETENGINE_KEY = 
        "org.openprivacy.reptile.xslt.StylesheetEngine";

    private static final String DEFAULT_ENGINE =
        "org.openprivacy.reptile.xslt.StreamStylesheetEngine";
    
    /**
     * Maps classnames to instances of StylesheetEngines
     */
    private static Hashtable engines = new Hashtable();

    /**
     * Get an instance of the correct StylesheetEngine to use 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton - burtonator</a>
     */
    public static final StylesheetEngine getStylesheetEngine() throws Exception {

        String instanceName = System.getProperty( ORG_OPENPRIVACY_REPTILE_XSLT_STYLESHEETENGINE_KEY );

        if ( instanceName == null )
            instanceName = DEFAULT_ENGINE;

        //try to get the instance to use from the known engines.  We only keep
        //around one copy of the engine at one VM runtime.

        StylesheetEngine engine = (StylesheetEngine)engines.get( instanceName );        

        if ( engine == null ) {

            //create an engine if it wasn't found in the cache
            
            engine = (StylesheetEngine)Class.forName( instanceName ).newInstance();

            //put it into the cache.            
            engines.put( instanceName, engine );
            
        }

        return engine;
        
    }

}

