/*
 * ---- 
 *
 * $Id: StylesheetEngine.java,v 1.1 2001/12/12 09:29:08 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 */

package org.openprivacy.reptile.xslt;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.dom.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.cache.sequence.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import javax.xml.transform.sax.*;

/**
 * Given an XML document and a StylesheetStack this will use TRAX to transform
 * all the content.  
 *
 * @version $Id: StylesheetEngine.java,v 1.1 2001/12/12 09:29:08 burton Exp $
 */
public interface StylesheetEngine {

    /**
     * @see #transform
     * @version $Id: StylesheetEngine.java,v 1.1 2001/12/12 09:29:08 burton Exp $
     */
    public String transform( SequenceDispatchEntry sde ) throws Exception;
    
    /**
     * Transform the given XML with all the given Stylesheets in the
     * StylesheetStack.  if Talon is in debug mode we will write out temp files
     * for debuging stylesheet output.
     *
     * If the given SequenceDispatchEntry is cacheable this might return content
     * from cache and skip any CPU intensive tasks.
     *
     * @version $Id: StylesheetEngine.java,v 1.1 2001/12/12 09:29:08 burton Exp $
     */
    public String transform( SequenceDispatchEntry sde,
                             ParameterPasser params ) throws Exception;
    
}

